/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.MouseInputAdapter;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.Marker;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.ChunkCache;
import org.gjt.sp.jedit.textarea.ExtensionManager;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.MouseActions;
import org.gjt.sp.jedit.textarea.StructureMatcher;
import org.gjt.sp.jedit.textarea.TextAreaExtension;
import org.gjt.sp.util.Log;

public class Gutter
extends JComponent
implements SwingConstants {
    public static final int LOWEST_LAYER = Integer.MIN_VALUE;
    public static final int DEFAULT_LAYER = 0;
    public static final int HIGHEST_LAYER = Integer.MAX_VALUE;
    private static final int FOLD_MARKER_SIZE = 12;
    private View view;
    private JEditTextArea textArea;
    private ExtensionManager extensionMgr;
    private int baseline;
    private Dimension gutterSize = new Dimension(0, 0);
    private Dimension collapsedSize = new Dimension(0, 0);
    private Color intervalHighlight;
    private Color currentLineHighlight;
    private Color foldColor;
    private FontMetrics fm;
    private int alignment;
    private int interval;
    private boolean currentLineHighlightEnabled;
    private boolean expanded;
    private boolean structureHighlight;
    private Color structureHighlightColor;
    private boolean markerHighlight;
    private Color markerHighlightColor;
    private int borderWidth;
    private Border focusBorder;
    private Border noFocusBorder;

    public Gutter(View view, JEditTextArea textArea) {
        this.view = view;
        this.textArea = textArea;
        this.setAutoscrolls(true);
        this.setOpaque(true);
        this.setRequestFocusEnabled(false);
        this.extensionMgr = new ExtensionManager();
        MouseHandler ml = new MouseHandler();
        this.addMouseListener(ml);
        this.addMouseMotionListener(ml);
        this.addExtension(new MarkerHighlight());
        this.updateBorder();
    }

    public void paintComponent(Graphics _gfx) {
        Graphics2D gfx = (Graphics2D)_gfx;
        Rectangle clip = gfx.getClipBounds();
        gfx.setColor(this.getBackground());
        gfx.fillRect(clip.x, clip.y, clip.width, clip.height);
        if (!this.textArea.getBuffer().isLoaded()) {
            return;
        }
        int lineHeight = this.textArea.getPainter().getFontMetrics().getHeight();
        if (lineHeight == 0) {
            return;
        }
        int lastLine = (clip.y + clip.height - 1) / lineHeight;
        int firstLine = clip.y / lineHeight;
        if (lastLine - firstLine > this.textArea.getVisibleLines()) {
            Log.log(9, this, "BUG: firstLine=" + firstLine);
            Log.log(9, this, "     lastLine=" + lastLine);
            Log.log(9, this, "     visibleLines=" + this.textArea.getVisibleLines());
            Log.log(9, this, "     height=" + this.getHeight());
            Log.log(9, this, "     painter.height=" + this.textArea.getPainter().getHeight());
            Log.log(9, this, "     clip.y=" + clip.y);
            Log.log(9, this, "     clip.height=" + clip.height);
            Log.log(9, this, "     lineHeight=" + lineHeight);
        }
        int y = clip.y - clip.y % lineHeight;
        this.extensionMgr.paintScreenLineRange(this.textArea, gfx, firstLine, lastLine, y, lineHeight);
        int line = firstLine;
        while (line <= lastLine) {
            this.paintLine(gfx, line, y);
            ++line;
            y += lineHeight;
        }
    }

    public void addExtension(TextAreaExtension extension) {
        this.extensionMgr.addExtension(0, extension);
        this.repaint();
    }

    public void addExtension(int layer, TextAreaExtension extension) {
        this.extensionMgr.addExtension(layer, extension);
        this.repaint();
    }

    public void removeExtension(TextAreaExtension extension) {
        this.extensionMgr.removeExtension(extension);
        this.repaint();
    }

    public TextAreaExtension[] getExtensions() {
        return this.extensionMgr.getExtensions();
    }

    public String getToolTipText(MouseEvent evt) {
        if (!this.textArea.getBuffer().isLoaded()) {
            return null;
        }
        return this.extensionMgr.getToolTipText(evt.getX(), evt.getY());
    }

    public void setBorder(int width, Color color1, Color color2, Color color3) {
        this.borderWidth = width;
        this.focusBorder = new CompoundBorder(new MatteBorder(0, 0, 0, width, color3), new MatteBorder(0, 0, 0, width, color1));
        this.noFocusBorder = new CompoundBorder(new MatteBorder(0, 0, 0, width, color3), new MatteBorder(0, 0, 0, width, color2));
        this.updateBorder();
    }

    public void updateBorder() {
        if (this.view.getEditPane() == null) {
            this.setBorder(this.noFocusBorder);
        } else if (this.view.getEditPane().getTextArea() == this.textArea) {
            this.setBorder(this.focusBorder);
        } else {
            this.setBorder(this.noFocusBorder);
        }
    }

    public void setBorder(Border border) {
        super.setBorder(border);
        if (border == null) {
            this.collapsedSize.width = 0;
            this.collapsedSize.height = 0;
        } else {
            Insets insets = border.getBorderInsets(this);
            this.collapsedSize.width = 12 + insets.right;
            this.collapsedSize.height = this.gutterSize.height = insets.top + insets.bottom;
            this.gutterSize.width = 12 + insets.right + this.fm.stringWidth("12345");
        }
        this.revalidate();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.fm = this.getFontMetrics(font);
        this.baseline = this.fm.getAscent();
        Border border = this.getBorder();
        if (border != null) {
            this.gutterSize.width = 12 + border.getBorderInsets((Component)this).right + this.fm.stringWidth("12345");
            this.revalidate();
        }
    }

    public Color getHighlightedForeground() {
        return this.intervalHighlight;
    }

    public void setHighlightedForeground(Color highlight) {
        this.intervalHighlight = highlight;
    }

    public Color getCurrentLineForeground() {
        return this.currentLineHighlight;
    }

    public void setCurrentLineForeground(Color highlight) {
        this.currentLineHighlight = highlight;
    }

    public Color getFoldColor() {
        return this.foldColor;
    }

    public void setFoldColor(Color foldColor) {
        this.foldColor = foldColor;
    }

    public Dimension getPreferredSize() {
        if (this.expanded) {
            return this.gutterSize;
        }
        return this.collapsedSize;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public int getLineNumberAlignment() {
        return this.alignment;
    }

    public void setLineNumberAlignment(int alignment) {
        if (this.alignment == alignment) {
            return;
        }
        this.alignment = alignment;
        this.repaint();
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean expanded) {
        if (this.expanded == expanded) {
            return;
        }
        this.expanded = expanded;
        this.textArea.revalidate();
    }

    public void toggleExpanded() {
        this.setExpanded(!this.expanded);
    }

    public int getHighlightInterval() {
        return this.interval;
    }

    public void setHighlightInterval(int interval) {
        if (interval <= 1) {
            interval = 0;
        }
        this.interval = interval;
        this.repaint();
    }

    public boolean isCurrentLineHighlightEnabled() {
        return this.currentLineHighlightEnabled;
    }

    public void setCurrentLineHighlightEnabled(boolean enabled) {
        if (this.currentLineHighlightEnabled == enabled) {
            return;
        }
        this.currentLineHighlightEnabled = enabled;
        this.repaint();
    }

    public final Color getStructureHighlightColor() {
        return this.structureHighlightColor;
    }

    public final void setStructureHighlightColor(Color structureHighlightColor) {
        this.structureHighlightColor = structureHighlightColor;
        this.repaint();
    }

    public final boolean isStructureHighlightEnabled() {
        return this.structureHighlight;
    }

    public final void setStructureHighlightEnabled(boolean structureHighlight) {
        this.structureHighlight = structureHighlight;
        this.repaint();
    }

    public Color getMarkerHighlightColor() {
        return this.markerHighlightColor;
    }

    public void setMarkerHighlightColor(Color markerHighlightColor) {
        this.markerHighlightColor = markerHighlightColor;
    }

    public boolean isMarkerHighlightEnabled() {
        return this.markerHighlight;
    }

    public void setMarkerHighlightEnabled(boolean markerHighlight) {
        this.markerHighlight = markerHighlight;
    }

    private void paintLine(Graphics2D gfx, int line, int y) {
        Buffer buffer = this.textArea.getBuffer();
        if (!buffer.isLoaded()) {
            return;
        }
        int lineHeight = this.textArea.getPainter().getFontMetrics().getHeight();
        ChunkCache.LineInfo info = this.textArea.chunkCache.getLineInfo(line);
        int physicalLine = info.physicalLine;
        if (physicalLine == -1) {
            return;
        }
        if (info.firstSubregion && buffer.isFoldStart(physicalLine)) {
            int _y = y + lineHeight / 2;
            gfx.setColor(this.foldColor);
            if (this.textArea.displayManager.isLineVisible(physicalLine + 1)) {
                gfx.drawLine(1, _y - 3, 10, _y - 3);
                gfx.drawLine(2, _y - 2, 9, _y - 2);
                gfx.drawLine(3, _y - 1, 8, _y - 1);
                gfx.drawLine(4, _y, 7, _y);
                gfx.drawLine(5, _y + 1, 6, _y + 1);
            } else {
                gfx.drawLine(4, _y - 5, 4, _y + 4);
                gfx.drawLine(5, _y - 4, 5, _y + 3);
                gfx.drawLine(6, _y - 3, 6, _y + 2);
                gfx.drawLine(7, _y - 2, 7, _y + 1);
                gfx.drawLine(8, _y - 1, 8, _y);
            }
        } else if (info.lastSubregion && buffer.isFoldEnd(physicalLine)) {
            gfx.setColor(this.foldColor);
            int _y = y + lineHeight / 2;
            gfx.drawLine(4, _y, 4, _y + 3);
            gfx.drawLine(4, _y + 3, 7, _y + 3);
        } else if (this.structureHighlight) {
            StructureMatcher.Match match = this.textArea.getStructureMatch();
            int caretLine = this.textArea.getCaretLine();
            if (this.textArea.isStructureHighlightVisible() && physicalLine >= Math.min(caretLine, match.startLine) && physicalLine <= Math.max(caretLine, match.startLine)) {
                int structScreenLine;
                int caretScreenLine = caretLine > this.textArea.getLastPhysicalLine() ? Integer.MAX_VALUE : (this.textArea.displayManager.isLineVisible(this.textArea.getCaretLine()) ? this.textArea.getScreenLineOfOffset(this.textArea.getCaretPosition()) : -1);
                if (caretScreenLine > (structScreenLine = match.startLine > this.textArea.getLastPhysicalLine() ? Integer.MAX_VALUE : (this.textArea.displayManager.isLineVisible(match.startLine) ? this.textArea.getScreenLineOfOffset(match.start) : -1))) {
                    int tmp = caretScreenLine;
                    caretScreenLine = structScreenLine;
                    structScreenLine = tmp;
                }
                gfx.setColor(this.structureHighlightColor);
                if (structScreenLine != caretScreenLine) {
                    if (line == caretScreenLine) {
                        gfx.fillRect(5, y + lineHeight / 2, 5, 2);
                        gfx.fillRect(5, y + lineHeight / 2, 2, lineHeight - lineHeight / 2);
                    } else if (line == structScreenLine) {
                        gfx.fillRect(5, y, 2, lineHeight / 2);
                        gfx.fillRect(5, y + lineHeight / 2, 5, 2);
                    } else if (line > caretScreenLine && line < structScreenLine) {
                        gfx.fillRect(5, y, 2, lineHeight);
                    }
                }
            }
        }
        if (info.firstSubregion && this.expanded) {
            boolean highlightCurrentLine;
            int offset;
            String number = Integer.toString(physicalLine + 1);
            switch (this.alignment) {
                case 4: {
                    offset = this.gutterSize.width - this.collapsedSize.width - (this.fm.stringWidth(number) + 1);
                    break;
                }
                case 0: {
                    offset = (this.gutterSize.width - this.collapsedSize.width - this.fm.stringWidth(number)) / 2;
                    break;
                }
                default: {
                    offset = 0;
                }
            }
            boolean bl = highlightCurrentLine = this.currentLineHighlightEnabled && this.textArea.selection.size() == 0;
            if (physicalLine == this.textArea.getCaretLine() && highlightCurrentLine) {
                gfx.setColor(this.currentLineHighlight);
            } else if (this.interval > 1 && (line + this.textArea.getFirstLine() + 1) % this.interval == 0) {
                gfx.setColor(this.intervalHighlight);
            } else {
                gfx.setColor(this.getForeground());
            }
            gfx.drawString(number, 12 + offset, this.baseline + y);
        }
    }

    class MarkerHighlight
    extends TextAreaExtension {
        MarkerHighlight() {
        }

        public void paintValidLine(Graphics2D gfx, int screenLine, int physicalLine, int start, int end, int y) {
            Buffer buffer;
            if (Gutter.this.isMarkerHighlightEnabled() && (buffer = Gutter.this.textArea.getBuffer()).getMarkerInRange(start, end) != null) {
                gfx.setColor(Gutter.this.getMarkerHighlightColor());
                FontMetrics fm = Gutter.this.textArea.getPainter().getFontMetrics();
                gfx.fillRect(0, y, Gutter.this.textArea.getGutter().getWidth(), fm.getHeight());
            }
        }

        public String getToolTipText(int x, int y) {
            if (Gutter.this.isMarkerHighlightEnabled()) {
                int lineHeight = Gutter.this.textArea.getPainter().getFontMetrics().getHeight();
                if (lineHeight == 0) {
                    return null;
                }
                int line = y / lineHeight;
                int start = Gutter.this.textArea.getScreenLineStartOffset(line);
                int end = Gutter.this.textArea.getScreenLineEndOffset(line);
                if (start == -1 || end == -1) {
                    return null;
                }
                Marker marker = Gutter.this.textArea.getBuffer().getMarkerInRange(start, end);
                if (marker != null) {
                    char shortcut = marker.getShortcut();
                    if (shortcut == '\u0000') {
                        return jEdit.getProperty("view.gutter.marker.no-name");
                    }
                    Object[] args = new String[]{String.valueOf(shortcut)};
                    return jEdit.getProperty("view.gutter.marker", args);
                }
            }
            return null;
        }
    }

    class MouseHandler
    extends MouseInputAdapter {
        MouseActions mouseActions = new MouseActions("gutter");
        boolean drag;
        int toolTipInitialDelay;
        int toolTipReshowDelay;

        MouseHandler() {
        }

        public void mouseEntered(MouseEvent e) {
            ToolTipManager ttm = ToolTipManager.sharedInstance();
            this.toolTipInitialDelay = ttm.getInitialDelay();
            this.toolTipReshowDelay = ttm.getReshowDelay();
            ttm.setInitialDelay(0);
            ttm.setReshowDelay(0);
        }

        public void mouseExited(MouseEvent evt) {
            ToolTipManager ttm = ToolTipManager.sharedInstance();
            ttm.setInitialDelay(this.toolTipInitialDelay);
            ttm.setReshowDelay(this.toolTipReshowDelay);
        }

        /*
         * WARNING - void declaration
         */
        public void mousePressed(MouseEvent e) {
            Gutter.this.textArea.requestFocus();
            if (GUIUtilities.isPopupTrigger(e) || e.getX() >= Gutter.this.getWidth() - Gutter.this.borderWidth * 2) {
                e.translatePoint(-Gutter.this.getWidth(), 0);
                ((Gutter)Gutter.this).textArea.mouseHandler.mousePressed(e);
                this.drag = true;
            } else {
                void var6_6;
                String variant;
                String defaultAction;
                Buffer buffer = Gutter.this.textArea.getBuffer();
                int screenLine = e.getY() / Gutter.this.textArea.getPainter().getFontMetrics().getHeight();
                int line = ((Gutter)Gutter.this).textArea.chunkCache.getLineInfo((int)screenLine).physicalLine;
                if (line == -1) {
                    return;
                }
                if (buffer.isFoldStart(line)) {
                    defaultAction = "toggle-fold";
                    variant = "fold";
                } else if (Gutter.this.structureHighlight && Gutter.this.textArea.isStructureHighlightVisible() && Gutter.this.textArea.lineInStructureScope(line)) {
                    defaultAction = "match-struct";
                    variant = "struct";
                } else {
                    return;
                }
                String action = this.mouseActions.getActionForEvent(e, (String)var6_6);
                if (action == null) {
                    void var5_5;
                    action = var5_5;
                }
                StructureMatcher.Match match = Gutter.this.textArea.getStructureMatch();
                if (action.equals("select-fold")) {
                    ((Gutter)Gutter.this).textArea.displayManager.expandFold(line, true);
                    Gutter.this.textArea.selectFold(line);
                } else if (action.equals("narrow-fold")) {
                    int[] lines = buffer.getFoldAtLine(line);
                    ((Gutter)Gutter.this).textArea.displayManager.narrow(lines[0], lines[1]);
                } else if (action.startsWith("toggle-fold")) {
                    if (((Gutter)Gutter.this).textArea.displayManager.isLineVisible(line + 1)) {
                        ((Gutter)Gutter.this).textArea.displayManager.collapseFold(line);
                    } else if (action.endsWith("-fully")) {
                        ((Gutter)Gutter.this).textArea.displayManager.expandFold(line, true);
                    } else {
                        ((Gutter)Gutter.this).textArea.displayManager.expandFold(line, false);
                    }
                } else if (action.equals("match-struct")) {
                    if (match != null) {
                        Gutter.this.textArea.setCaretPosition(match.end);
                    }
                } else if (action.equals("select-struct")) {
                    if (match != null) {
                        match.matcher.selectMatch(Gutter.this.textArea);
                    }
                } else if (action.equals("narrow-struct") && match != null) {
                    int start = Math.min(match.startLine, Gutter.this.textArea.getCaretLine());
                    int end = Math.max(match.endLine, Gutter.this.textArea.getCaretLine());
                    ((Gutter)Gutter.this).textArea.displayManager.narrow(start, end);
                }
            }
        }

        public void mouseDragged(MouseEvent e) {
            if (this.drag) {
                e.translatePoint(-Gutter.this.getWidth(), 0);
                ((Gutter)Gutter.this).textArea.mouseHandler.mouseDragged(e);
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (this.drag && e.getX() >= Gutter.this.getWidth() - Gutter.this.borderWidth * 2) {
                e.translatePoint(-Gutter.this.getWidth(), 0);
                ((Gutter)Gutter.this).textArea.mouseHandler.mouseReleased(e);
            }
            this.drag = false;
        }
    }
}

