/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.syntax;

import java.util.Vector;
import javax.swing.text.Segment;
import org.gjt.sp.jedit.syntax.SyntaxUtilities;

public class KeywordMap {
    private int mapLength;
    private Keyword[] map;
    private boolean ignoreCase;
    private StringBuffer noWordSep;

    public KeywordMap(boolean ignoreCase) {
        this(ignoreCase, 52);
        this.ignoreCase = ignoreCase;
        this.noWordSep = new StringBuffer();
    }

    public KeywordMap(boolean ignoreCase, int mapLength) {
        this.mapLength = mapLength;
        this.ignoreCase = ignoreCase;
        this.map = new Keyword[mapLength];
    }

    public byte lookup(Segment text, int offset, int length) {
        if (length == 0) {
            return 0;
        }
        Keyword k = this.map[this.getSegmentMapKey(text, offset, length)];
        while (k != null) {
            if (length != k.keyword.length) {
                k = k.next;
                continue;
            }
            if (SyntaxUtilities.regionMatches(this.ignoreCase, text, offset, k.keyword)) {
                return k.id;
            }
            k = k.next;
        }
        return 0;
    }

    public void add(String keyword, byte id) {
        this.add(keyword.toCharArray(), id);
    }

    public void add(char[] keyword, byte id) {
        int key = this.getStringMapKey(keyword);
        block0: for (int i = 0; i < keyword.length; ++i) {
            char ch = keyword[i];
            if (Character.isLetterOrDigit(ch)) continue;
            for (int j = 0; j < this.noWordSep.length(); ++j) {
                if (this.noWordSep.charAt(j) == ch) continue block0;
            }
            this.noWordSep.append(ch);
        }
        this.map[key] = new Keyword(keyword, id, this.map[key]);
    }

    public String getNonAlphaNumericChars() {
        return this.noWordSep.toString();
    }

    public String[] getKeywords() {
        Vector<String> vector = new Vector<String>(100);
        for (int i = 0; i < this.map.length; ++i) {
            Keyword keyword = this.map[i];
            while (keyword != null) {
                vector.addElement(new String(keyword.keyword));
                keyword = keyword.next;
            }
        }
        Object[] retVal = new String[vector.size()];
        vector.copyInto(retVal);
        return retVal;
    }

    public boolean getIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public void add(KeywordMap map) {
        for (int i = 0; i < map.map.length; ++i) {
            Keyword k = map.map[i];
            while (k != null) {
                this.add(k.keyword, k.id);
                k = k.next;
            }
        }
    }

    private int getStringMapKey(char[] s) {
        return (Character.toUpperCase(s[0]) + Character.toUpperCase(s[s.length - 1])) % this.mapLength;
    }

    protected int getSegmentMapKey(Segment s, int off, int len) {
        return (Character.toUpperCase(s.array[off]) + Character.toUpperCase(s.array[off + len - 1])) % this.mapLength;
    }

    class Keyword {
        public char[] keyword;
        public byte id;
        public Keyword next;

        public Keyword(char[] keyword, byte id, Keyword next) {
            this.keyword = keyword;
            this.id = id;
            this.next = next;
        }
    }
}

