/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.pluginmgr;

import com.microstar.xml.XmlParser;
import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import org.gjt.sp.jedit.EditPlugin;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.PluginJAR;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.pluginmgr.PluginListHandler;
import org.gjt.sp.jedit.pluginmgr.Roster;
import org.gjt.sp.util.Log;

class PluginList {
    public static final int GZIP_MAGIC_1 = 31;
    public static final int GZIP_MAGIC_2 = 139;
    Vector plugins = new Vector();
    Hashtable pluginHash = new Hashtable();
    Vector pluginSets = new Vector();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PluginList() throws Exception {
        String path = jEdit.getProperty("plugin-manager.export-url");
        String id = jEdit.getProperty("plugin-manager.mirror.id");
        if (!id.equals("NONE")) {
            path = path + "?mirror=" + id;
        }
        PluginListHandler handler = new PluginListHandler(this, path);
        XmlParser parser = new XmlParser();
        parser.setHandler(handler);
        FilterInputStream in = new BufferedInputStream(new URL(path).openStream());
        try {
            if (((InputStream)in).markSupported()) {
                ((InputStream)in).mark(2);
                int b1 = ((InputStream)in).read();
                int b2 = ((InputStream)in).read();
                ((InputStream)in).reset();
                if (b1 == 31 && b2 == 139) {
                    in = new GZIPInputStream(in);
                }
            }
            parser.parse(null, null, new InputStreamReader((InputStream)in, "UTF8"));
        }
        finally {
            ((InputStream)in).close();
        }
    }

    void addPlugin(Plugin plugin) {
        plugin.checkIfInstalled();
        this.plugins.addElement(plugin);
        this.pluginHash.put(plugin.name, plugin);
    }

    void addPluginSet(PluginSet set) {
        this.pluginSets.addElement(set);
    }

    void finished() {
        for (int i = 0; i < this.plugins.size(); ++i) {
            Plugin plugin = (Plugin)this.plugins.elementAt(i);
            for (int j = 0; j < plugin.branches.size(); ++j) {
                Branch branch = (Branch)plugin.branches.elementAt(j);
                for (int k = 0; k < branch.deps.size(); ++k) {
                    Dependency dep = (Dependency)branch.deps.elementAt(k);
                    if (!dep.what.equals("plugin")) continue;
                    dep.plugin = (Plugin)this.pluginHash.get(dep.pluginName);
                }
            }
        }
    }

    void dump() {
        for (int i = 0; i < this.plugins.size(); ++i) {
            System.err.println((Plugin)this.plugins.elementAt(i));
            System.err.println();
        }
    }

    static class Dependency {
        String what;
        String from;
        String to;
        String pluginName;
        Plugin plugin;

        Dependency(String what, String from, String to, String pluginName) {
            this.what = what;
            this.from = from;
            this.to = to;
            this.pluginName = pluginName;
        }

        boolean isSatisfied() {
            if (this.what.equals("plugin")) {
                for (int i = 0; i < this.plugin.branches.size(); ++i) {
                    String installedVersion = this.plugin.getInstalledVersion();
                    if (installedVersion == null || this.from != null && MiscUtilities.compareStrings(installedVersion, this.from, false) < 0 || this.to != null && MiscUtilities.compareStrings(installedVersion, this.to, false) > 0) continue;
                    return true;
                }
                return false;
            }
            if (this.what.equals("jdk")) {
                String javaVersion = System.getProperty("java.version").substring(0, 3);
                return !(this.from != null && MiscUtilities.compareStrings(javaVersion, this.from, false) < 0 || this.to != null && MiscUtilities.compareStrings(javaVersion, this.to, false) > 0);
            }
            if (this.what.equals("jedit")) {
                String build = jEdit.getBuild();
                return !(this.from != null && MiscUtilities.compareStrings(build, this.from, false) < 0 || this.to != null && MiscUtilities.compareStrings(build, this.to, false) > 0);
            }
            Log.log(9, this, "Invalid dependency: " + this.what);
            return false;
        }

        boolean canSatisfy() {
            if (this.isSatisfied()) {
                return true;
            }
            if (this.what.equals("plugin")) {
                return this.plugin.canBeInstalled();
            }
            return false;
        }

        void satisfy(Roster roster, String installDirectory, boolean downloadSource) {
            if (this.what.equals("plugin")) {
                String installedVersion = this.plugin.getInstalledVersion();
                for (int i = 0; i < this.plugin.branches.size(); ++i) {
                    Branch branch = (Branch)this.plugin.branches.elementAt(i);
                    if (installedVersion != null && MiscUtilities.compareStrings(installedVersion, branch.version, false) >= 0 || this.from != null && MiscUtilities.compareStrings(branch.version, this.from, false) < 0 || this.to != null && MiscUtilities.compareStrings(branch.version, this.to, false) > 0) continue;
                    this.plugin.install(roster, installDirectory, downloadSource);
                    return;
                }
            }
        }

        public String toString() {
            return "[what=" + this.what + ",from=" + this.from + ",to=" + this.to + ",plugin=" + this.plugin + "]";
        }
    }

    static class Branch {
        String version;
        String date;
        int downloadSize;
        String download;
        int downloadSourceSize;
        String downloadSource;
        boolean obsolete;
        Vector deps = new Vector();

        Branch() {
        }

        boolean canSatisfyDependencies() {
            for (int i = 0; i < this.deps.size(); ++i) {
                Dependency dep = (Dependency)this.deps.elementAt(i);
                if (dep.canSatisfy()) continue;
                return false;
            }
            return true;
        }

        void satisfyDependencies(Roster roster, String installDirectory, boolean downloadSource) {
            for (int i = 0; i < this.deps.size(); ++i) {
                Dependency dep = (Dependency)this.deps.elementAt(i);
                dep.satisfy(roster, installDirectory, downloadSource);
            }
        }

        public String toString() {
            return "[version=" + this.version + ",download=" + this.download + ",obsolete=" + this.obsolete + ",deps=" + this.deps + "]";
        }
    }

    public static class Plugin {
        String jar;
        String name;
        String description;
        String author;
        Vector branches = new Vector();

        void checkIfInstalled() {
        }

        String getInstalledVersion() {
            PluginJAR[] jars = jEdit.getPluginJARs();
            for (int i = 0; i < jars.length; ++i) {
                String path = jars[i].getPath();
                if (!MiscUtilities.getFileName(path).equals(this.jar)) continue;
                EditPlugin plugin = jars[i].getPlugin();
                if (plugin != null) {
                    return jEdit.getProperty("plugin." + plugin.getClassName() + ".version");
                }
                return null;
            }
            return null;
        }

        String getInstalledPath() {
            PluginJAR[] jars = jEdit.getPluginJARs();
            for (int i = 0; i < jars.length; ++i) {
                String path = jars[i].getPath();
                if (!MiscUtilities.getFileName(path).equals(this.jar)) continue;
                return path;
            }
            return null;
        }

        Branch getCompatibleBranch() {
            for (int i = 0; i < this.branches.size(); ++i) {
                Branch branch = (Branch)this.branches.elementAt(i);
                if (!branch.canSatisfyDependencies()) continue;
                return branch;
            }
            return null;
        }

        boolean canBeInstalled() {
            Branch branch = this.getCompatibleBranch();
            return branch != null && !branch.obsolete && branch.canSatisfyDependencies();
        }

        void install(Roster roster, String installDirectory, boolean downloadSource) {
            String installed = this.getInstalledPath();
            Branch branch = this.getCompatibleBranch();
            if (branch.obsolete) {
                if (installed != null) {
                    roster.addRemove(installed);
                }
                return;
            }
            if (installed != null) {
                installDirectory = MiscUtilities.getParentOfPath(installed);
            }
            roster.addInstall(installed, downloadSource ? branch.downloadSource : branch.download, installDirectory, downloadSource ? branch.downloadSourceSize : branch.downloadSize);
        }

        public String toString() {
            return this.name;
        }
    }

    static class PluginSet {
        String name;
        String description;
        Vector plugins = new Vector();

        PluginSet() {
        }

        public String toString() {
            return this.plugins.toString();
        }
    }
}

