/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import org.gjt.sp.jedit.ActionSet;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.options.ToolBarOptionPane;
import org.gjt.sp.util.Log;

class ToolBarEditDialog
extends EnhancedDialog {
    private boolean isOK;
    private JRadioButton separator;
    private JRadioButton action;
    private JComboBox combo;
    private JList list;
    private JRadioButton builtin;
    private JComboBox builtinCombo;
    private JRadioButton file;
    private JButton fileButton;
    private String fileIcon;
    private JButton ok;
    private JButton cancel;

    public ToolBarEditDialog(Component comp, DefaultComboBoxModel iconListModel, ToolBarOptionPane.Button current) {
        super(GUIUtilities.getParentDialog(comp), jEdit.getProperty("options.toolbar.edit.title"), true);
        JPanel content = new JPanel(new BorderLayout());
        content.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(content);
        ActionHandler actionHandler = new ActionHandler();
        ButtonGroup grp = new ButtonGroup();
        JPanel typePanel = new JPanel(new GridLayout(3, 1, 6, 6));
        typePanel.setBorder(new EmptyBorder(0, 0, 6, 0));
        typePanel.add(new JLabel(jEdit.getProperty("options.toolbar.edit.caption")));
        this.separator = new JRadioButton(jEdit.getProperty("options.toolbar.edit.separator"));
        this.separator.addActionListener(actionHandler);
        grp.add(this.separator);
        typePanel.add(this.separator);
        this.action = new JRadioButton(jEdit.getProperty("options.toolbar.edit.action"));
        this.action.addActionListener(actionHandler);
        grp.add(this.action);
        typePanel.add(this.action);
        content.add("North", typePanel);
        JPanel actionPanel = new JPanel(new BorderLayout(6, 6));
        ActionSet[] actionsList = jEdit.getActionSets();
        Vector<ActionSet> vec = new Vector<ActionSet>(actionsList.length);
        for (int i = 0; i < actionsList.length; ++i) {
            ActionSet actionSet = actionsList[i];
            if (actionSet.getActionCount() == 0) continue;
            vec.addElement(actionSet);
        }
        this.combo = new JComboBox(vec);
        this.combo.addActionListener(actionHandler);
        actionPanel.add("North", this.combo);
        this.list = new JList();
        this.list.setVisibleRowCount(8);
        this.list.setSelectionMode(0);
        actionPanel.add("Center", new JScrollPane(this.list));
        JPanel iconPanel = new JPanel(new BorderLayout(0, 3));
        JPanel labelPanel = new JPanel(new GridLayout(2, 1));
        labelPanel.setBorder(new EmptyBorder(0, 0, 0, 12));
        JPanel compPanel = new JPanel(new GridLayout(2, 1));
        grp = new ButtonGroup();
        this.builtin = new JRadioButton(jEdit.getProperty("options.toolbar.edit.builtin"));
        labelPanel.add(this.builtin);
        this.builtin.addActionListener(actionHandler);
        grp.add(this.builtin);
        this.file = new JRadioButton(jEdit.getProperty("options.toolbar.edit.file"));
        labelPanel.add(this.file);
        grp.add(this.file);
        this.file.addActionListener(actionHandler);
        iconPanel.add("West", labelPanel);
        this.builtinCombo = new JComboBox(iconListModel);
        this.builtinCombo.setRenderer(new ToolBarOptionPane.IconCellRenderer());
        compPanel.add(this.builtinCombo);
        this.fileButton = new JButton(jEdit.getProperty("options.toolbar.edit.no-icon"));
        this.fileButton.setMargin(new Insets(1, 1, 1, 1));
        this.fileButton.setIcon(GUIUtilities.loadIcon("Blank24.gif"));
        this.fileButton.setHorizontalAlignment(2);
        this.fileButton.addActionListener(actionHandler);
        compPanel.add(this.fileButton);
        iconPanel.add("Center", compPanel);
        actionPanel.add("South", iconPanel);
        content.add("Center", actionPanel);
        JPanel southPanel = new JPanel();
        southPanel.setLayout(new BoxLayout(southPanel, 0));
        southPanel.setBorder(new EmptyBorder(12, 0, 0, 0));
        southPanel.add(Box.createGlue());
        this.ok = new JButton(jEdit.getProperty("common.ok"));
        this.ok.addActionListener(actionHandler);
        this.getRootPane().setDefaultButton(this.ok);
        southPanel.add(this.ok);
        southPanel.add(Box.createHorizontalStrut(6));
        this.cancel = new JButton(jEdit.getProperty("common.cancel"));
        this.cancel.addActionListener(actionHandler);
        southPanel.add(this.cancel);
        southPanel.add(Box.createGlue());
        content.add("South", southPanel);
        if (current == null) {
            this.action.setSelected(true);
            this.builtin.setSelected(true);
            this.updateList();
        } else if (current.actionName.equals("-")) {
            this.separator.setSelected(true);
            this.builtin.setSelected(true);
        } else {
            this.action.setSelected(true);
            ActionSet set = jEdit.getActionSetForAction(current.actionName);
            this.combo.setSelectedItem(set);
            this.updateList();
            this.list.setSelectedValue(current, true);
            if (MiscUtilities.isURL(current.iconName)) {
                this.file.setSelected(true);
                this.fileIcon = current.iconName;
                try {
                    this.fileButton.setIcon(new ImageIcon(new URL(this.fileIcon)));
                }
                catch (MalformedURLException mf) {
                    Log.log(9, this, mf);
                }
                this.fileButton.setText(MiscUtilities.getFileName(this.fileIcon));
            } else {
                String iconName = MiscUtilities.getFileName(current.iconName);
                this.builtin.setSelected(true);
                ComboBoxModel model = this.builtinCombo.getModel();
                for (int i = 0; i < model.getSize(); ++i) {
                    ToolBarOptionPane.IconListEntry entry = (ToolBarOptionPane.IconListEntry)model.getElementAt(i);
                    if (!entry.name.equals(iconName)) continue;
                    this.builtinCombo.setSelectedIndex(i);
                    break;
                }
            }
        }
        this.updateEnabled();
        this.pack();
        this.setLocationRelativeTo(GUIUtilities.getParentDialog(comp));
        this.setVisible(true);
    }

    public void ok() {
        this.isOK = true;
        this.dispose();
    }

    public void cancel() {
        this.dispose();
    }

    public ToolBarOptionPane.Button getSelection() {
        String iconName;
        Icon icon;
        if (!this.isOK) {
            return null;
        }
        if (this.separator.isSelected()) {
            return new ToolBarOptionPane.Button("-", null, null, "-");
        }
        if (this.builtin.isSelected()) {
            ToolBarOptionPane.IconListEntry selectedIcon = (ToolBarOptionPane.IconListEntry)this.builtinCombo.getSelectedItem();
            icon = selectedIcon.icon;
            iconName = selectedIcon.name;
        } else {
            icon = this.fileButton.getIcon();
            iconName = this.fileIcon;
            if (iconName == null) {
                iconName = "Blank24.gif";
            }
        }
        if (!this.action.isSelected()) {
            throw new InternalError();
        }
        ToolBarOptionPane.Button button = (ToolBarOptionPane.Button)this.list.getSelectedValue();
        String label = button.label;
        String actionName = button.actionName;
        return new ToolBarOptionPane.Button(actionName, iconName, icon, label);
    }

    private void updateEnabled() {
        this.combo.setEnabled(this.action.isSelected());
        this.list.setEnabled(this.action.isSelected());
        boolean iconControlsEnabled = !this.separator.isSelected();
        this.builtin.setEnabled(iconControlsEnabled);
        this.file.setEnabled(iconControlsEnabled);
        this.builtinCombo.setEnabled(iconControlsEnabled && this.builtin.isSelected());
        this.fileButton.setEnabled(iconControlsEnabled && this.file.isSelected());
    }

    private void updateList() {
        ActionSet actionSet = (ActionSet)this.combo.getSelectedItem();
        EditAction[] actions = actionSet.getActions();
        Vector<ToolBarOptionPane.Button> listModel = new Vector<ToolBarOptionPane.Button>(actions.length);
        for (int i = 0; i < actions.length; ++i) {
            EditAction action = actions[i];
            String label = action.getLabel();
            if (label == null) continue;
            listModel.addElement(new ToolBarOptionPane.Button(action.getName(), null, null, label));
        }
        MiscUtilities.quicksort(listModel, (MiscUtilities.Compare)new ToolBarOptionPane.ButtonCompare());
        this.list.setListData(listModel);
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            if (source instanceof JRadioButton) {
                ToolBarEditDialog.this.updateEnabled();
            }
            if (source == ToolBarEditDialog.this.ok) {
                ToolBarEditDialog.this.ok();
            } else if (source == ToolBarEditDialog.this.cancel) {
                ToolBarEditDialog.this.cancel();
            } else if (source == ToolBarEditDialog.this.combo) {
                ToolBarEditDialog.this.updateList();
            } else if (source == ToolBarEditDialog.this.fileButton) {
                String directory = ToolBarEditDialog.this.fileIcon == null ? null : MiscUtilities.getParentOfPath(ToolBarEditDialog.this.fileIcon);
                String[] paths = GUIUtilities.showVFSFileDialog(null, directory, 0, false);
                if (paths == null) {
                    return;
                }
                ToolBarEditDialog.this.fileIcon = "file:" + paths[0];
                try {
                    ToolBarEditDialog.this.fileButton.setIcon(new ImageIcon(new URL(ToolBarEditDialog.this.fileIcon)));
                }
                catch (MalformedURLException mf) {
                    Log.log(9, this, mf);
                }
                ToolBarEditDialog.this.fileButton.setText(MiscUtilities.getFileName(ToolBarEditDialog.this.fileIcon));
            }
        }
    }
}

