/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.options.ContextAddDialog;

public class ContextOptionPane
extends AbstractOptionPane {
    private DefaultListModel listModel;
    private JList list;
    private JButton add;
    private JButton remove;
    private JButton moveUp;
    private JButton moveDown;

    public ContextOptionPane() {
        super("context");
    }

    protected void _init() {
        this.setLayout(new BorderLayout());
        JLabel caption = new JLabel(jEdit.getProperty("options.context.caption"));
        this.add("North", caption);
        String contextMenu = jEdit.getProperty("view.context");
        StringTokenizer st = new StringTokenizer(contextMenu);
        this.listModel = new DefaultListModel();
        while (st.hasMoreTokens()) {
            String label;
            String actionName = st.nextToken();
            if (actionName.equals("-")) {
                this.listModel.addElement(new MenuItem("-", "-"));
                continue;
            }
            EditAction action = jEdit.getAction(actionName);
            if (action == null || (label = action.getLabel()) == null) continue;
            this.listModel.addElement(new MenuItem(actionName, label));
        }
        this.list = new JList(this.listModel);
        this.list.setSelectionMode(0);
        this.list.addListSelectionListener(new ListHandler());
        this.add("Center", new JScrollPane(this.list));
        JPanel buttons = new JPanel();
        buttons.setBorder(new EmptyBorder(3, 0, 0, 0));
        buttons.setLayout(new BoxLayout(buttons, 0));
        ActionHandler actionHandler = new ActionHandler();
        this.add = new RolloverButton(GUIUtilities.loadIcon("Plus.png"));
        this.add.setToolTipText(jEdit.getProperty("common.add"));
        this.add.addActionListener(actionHandler);
        buttons.add(this.add);
        buttons.add(Box.createHorizontalStrut(6));
        this.remove = new RolloverButton(GUIUtilities.loadIcon("Minus.png"));
        this.remove.setToolTipText(jEdit.getProperty("common.remove"));
        this.remove.addActionListener(actionHandler);
        buttons.add(this.remove);
        buttons.add(Box.createHorizontalStrut(6));
        this.moveUp = new RolloverButton(GUIUtilities.loadIcon("ArrowU.png"));
        this.moveUp.setToolTipText(jEdit.getProperty("common.moveUp"));
        this.moveUp.addActionListener(actionHandler);
        buttons.add(this.moveUp);
        buttons.add(Box.createHorizontalStrut(6));
        this.moveDown = new RolloverButton(GUIUtilities.loadIcon("ArrowD.png"));
        this.moveDown.setToolTipText(jEdit.getProperty("common.moveDown"));
        this.moveDown.addActionListener(actionHandler);
        buttons.add(this.moveDown);
        buttons.add(Box.createGlue());
        this.updateButtons();
        this.add("South", buttons);
    }

    protected void _save() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.listModel.getSize(); ++i) {
            if (i != 0) {
                buf.append(' ');
            }
            buf.append(((MenuItem)this.listModel.elementAt((int)i)).actionName);
        }
        jEdit.setProperty("view.context", buf.toString());
    }

    private void updateButtons() {
        int index = this.list.getSelectedIndex();
        this.remove.setEnabled(index != -1 && this.listModel.getSize() != 0);
        this.moveUp.setEnabled(index > 0);
        this.moveDown.setEnabled(index != -1 && index != this.listModel.getSize() - 1);
    }

    class ListHandler
    implements ListSelectionListener {
        ListHandler() {
        }

        public void valueChanged(ListSelectionEvent evt) {
            ContextOptionPane.this.updateButtons();
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            if (source == ContextOptionPane.this.add) {
                ContextAddDialog dialog = new ContextAddDialog(ContextOptionPane.this);
                String selection = dialog.getSelection();
                if (selection == null) {
                    return;
                }
                int index = ContextOptionPane.this.list.getSelectedIndex();
                index = index == -1 ? ContextOptionPane.this.listModel.getSize() : ++index;
                MenuItem menuItem = selection.equals("-") ? new MenuItem("-", "-") : new MenuItem(selection, jEdit.getAction(selection).getLabel());
                ContextOptionPane.this.listModel.insertElementAt(menuItem, index);
                ContextOptionPane.this.list.setSelectedIndex(index);
                ContextOptionPane.this.list.ensureIndexIsVisible(index);
            } else if (source == ContextOptionPane.this.remove) {
                int index = ContextOptionPane.this.list.getSelectedIndex();
                ContextOptionPane.this.listModel.removeElementAt(index);
                if (ContextOptionPane.this.listModel.getSize() != 0) {
                    ContextOptionPane.this.list.setSelectedIndex(Math.min(ContextOptionPane.this.listModel.getSize() - 1, index));
                }
                ContextOptionPane.this.updateButtons();
            } else if (source == ContextOptionPane.this.moveUp) {
                int index = ContextOptionPane.this.list.getSelectedIndex();
                Object selected = ContextOptionPane.this.list.getSelectedValue();
                ContextOptionPane.this.listModel.removeElementAt(index);
                ContextOptionPane.this.listModel.insertElementAt(selected, index - 1);
                ContextOptionPane.this.list.setSelectedIndex(index - 1);
                ContextOptionPane.this.list.ensureIndexIsVisible(index - 1);
            } else if (source == ContextOptionPane.this.moveDown) {
                int index = ContextOptionPane.this.list.getSelectedIndex();
                Object selected = ContextOptionPane.this.list.getSelectedValue();
                ContextOptionPane.this.listModel.removeElementAt(index);
                ContextOptionPane.this.listModel.insertElementAt(selected, index + 1);
                ContextOptionPane.this.list.setSelectedIndex(index + 1);
                ContextOptionPane.this.list.ensureIndexIsVisible(index + 1);
            }
        }
    }

    static class MenuItem {
        String actionName;
        String label;

        MenuItem(String actionName, String label) {
            this.actionName = actionName;
            this.label = GUIUtilities.prettifyMenuLabel(label);
        }

        public String toString() {
            return this.label;
        }
    }

    static class MenuItemCompare
    implements MiscUtilities.Compare {
        MenuItemCompare() {
        }

        public int compare(Object obj1, Object obj2) {
            return MiscUtilities.compareStrings(((MenuItem)obj1).label, ((MenuItem)obj2).label, true);
        }
    }
}

