/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import org.gjt.sp.jedit.ActionSet;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.options.ContextOptionPane;

class ContextAddDialog
extends EnhancedDialog {
    private boolean isOK;
    private JRadioButton separator;
    private JRadioButton action;
    private JComboBox combo;
    private JList list;
    private JButton ok;
    private JButton cancel;

    public ContextAddDialog(Component comp) {
        super(GUIUtilities.getParentDialog(comp), jEdit.getProperty("options.context.add.title"), true);
        JPanel content = new JPanel(new BorderLayout());
        content.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(content);
        ActionHandler actionHandler = new ActionHandler();
        ButtonGroup grp = new ButtonGroup();
        JPanel typePanel = new JPanel(new GridLayout(3, 1, 6, 6));
        typePanel.setBorder(new EmptyBorder(0, 0, 6, 0));
        typePanel.add(new JLabel(jEdit.getProperty("options.context.add.caption")));
        this.separator = new JRadioButton(jEdit.getProperty("options.context.add.separator"));
        this.separator.addActionListener(actionHandler);
        grp.add(this.separator);
        typePanel.add(this.separator);
        this.action = new JRadioButton(jEdit.getProperty("options.context.add.action"));
        this.action.addActionListener(actionHandler);
        grp.add(this.action);
        this.action.setSelected(true);
        typePanel.add(this.action);
        content.add("North", typePanel);
        JPanel actionPanel = new JPanel(new BorderLayout(6, 6));
        ActionSet[] actionsList = jEdit.getActionSets();
        Vector<ActionSet> vec = new Vector<ActionSet>(actionsList.length);
        for (int i = 0; i < actionsList.length; ++i) {
            ActionSet actionSet = actionsList[i];
            if (actionSet.getActionCount() == 0) continue;
            vec.addElement(actionSet);
        }
        this.combo = new JComboBox(vec);
        this.combo.addActionListener(actionHandler);
        actionPanel.add("North", this.combo);
        this.list = new JList();
        this.list.setVisibleRowCount(8);
        this.list.setSelectionMode(0);
        actionPanel.add("Center", new JScrollPane(this.list));
        content.add("Center", actionPanel);
        JPanel southPanel = new JPanel();
        southPanel.setLayout(new BoxLayout(southPanel, 0));
        southPanel.setBorder(new EmptyBorder(12, 0, 0, 0));
        southPanel.add(Box.createGlue());
        this.ok = new JButton(jEdit.getProperty("common.ok"));
        this.ok.addActionListener(actionHandler);
        this.getRootPane().setDefaultButton(this.ok);
        southPanel.add(this.ok);
        southPanel.add(Box.createHorizontalStrut(6));
        this.cancel = new JButton(jEdit.getProperty("common.cancel"));
        this.cancel.addActionListener(actionHandler);
        southPanel.add(this.cancel);
        southPanel.add(Box.createGlue());
        content.add("South", southPanel);
        this.updateList();
        this.pack();
        this.setLocationRelativeTo(GUIUtilities.getParentDialog(comp));
        this.setVisible(true);
    }

    public void ok() {
        this.isOK = true;
        this.dispose();
    }

    public void cancel() {
        this.dispose();
    }

    public String getSelection() {
        if (!this.isOK) {
            return null;
        }
        if (this.separator.isSelected()) {
            return "-";
        }
        if (this.action.isSelected()) {
            return ((ContextOptionPane.MenuItem)this.list.getSelectedValue()).actionName;
        }
        throw new InternalError();
    }

    private void updateList() {
        ActionSet actionSet = (ActionSet)this.combo.getSelectedItem();
        EditAction[] actions = actionSet.getActions();
        Vector<ContextOptionPane.MenuItem> listModel = new Vector<ContextOptionPane.MenuItem>(actions.length);
        for (int i = 0; i < actions.length; ++i) {
            EditAction action = actions[i];
            String label = action.getLabel();
            if (label == null) continue;
            listModel.addElement(new ContextOptionPane.MenuItem(action.getName(), label));
        }
        MiscUtilities.quicksort(listModel, (MiscUtilities.Compare)new ContextOptionPane.MenuItemCompare());
        this.list.setListData(listModel);
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            if (source instanceof JRadioButton) {
                ContextAddDialog.this.combo.setEnabled(ContextAddDialog.this.action.isSelected());
                ContextAddDialog.this.list.setEnabled(ContextAddDialog.this.action.isSelected());
            }
            if (source == ContextAddDialog.this.ok) {
                ContextAddDialog.this.ok();
            } else if (source == ContextAddDialog.this.cancel) {
                ContextAddDialog.this.cancel();
            } else if (source == ContextAddDialog.this.combo) {
                ContextAddDialog.this.updateList();
            }
        }
    }
}

