/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.menu;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import org.gjt.sp.jedit.ActionContext;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.jEdit;

public class EnhancedMenuItem
extends JMenuItem {
    static Font acceleratorFont;
    static Color acceleratorForeground;
    static Color acceleratorSelectionForeground;
    private String shortcut;
    private String action;

    public EnhancedMenuItem(String label, String action, ActionContext context) {
        this.action = action;
        this.shortcut = this.getShortcut();
        if (OperatingSystem.hasScreenMenuBar() && this.shortcut != null) {
            this.setText(label + " (" + this.shortcut + ")");
            this.shortcut = null;
        } else {
            this.setText(label);
        }
        if (action != null) {
            this.setEnabled(true);
            this.addActionListener(new EditAction.Wrapper(context, action));
            this.addMouseListener(new MouseHandler());
        } else {
            this.setEnabled(false);
        }
    }

    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        if (this.shortcut != null) {
            d.width += this.getFontMetrics(acceleratorFont).stringWidth(this.shortcut) + 15;
        }
        return d;
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.shortcut != null) {
            g.setFont(acceleratorFont);
            g.setColor(this.getModel().isArmed() ? acceleratorSelectionForeground : acceleratorForeground);
            FontMetrics fm = g.getFontMetrics();
            Insets insets = this.getInsets();
            g.drawString(this.shortcut, this.getWidth() - (fm.stringWidth(this.shortcut) + insets.right + insets.left + 5), this.getFont().getSize() + (insets.top - (OperatingSystem.isMacOSLF() ? 0 : 1)));
        }
    }

    private String getShortcut() {
        if (this.action == null) {
            return null;
        }
        String shortcut1 = jEdit.getProperty(this.action + ".shortcut");
        String shortcut2 = jEdit.getProperty(this.action + ".shortcut2");
        if (shortcut1 == null || shortcut1.length() == 0) {
            if (shortcut2 == null || shortcut2.length() == 0) {
                return null;
            }
            return shortcut2;
        }
        if (shortcut2 == null || shortcut2.length() == 0) {
            return shortcut1;
        }
        return shortcut1 + " or " + shortcut2;
    }

    static {
        String shortcutFont = OperatingSystem.isMacOSLF() ? "Lucida Grande" : "Monospaced";
        acceleratorFont = UIManager.getFont("MenuItem.acceleratorFont");
        acceleratorFont = acceleratorFont == null ? new Font(shortcutFont, 0, 12) : new Font(shortcutFont, acceleratorFont.getStyle(), acceleratorFont.getSize());
        acceleratorForeground = UIManager.getColor("MenuItem.acceleratorForeground");
        if (acceleratorForeground == null) {
            acceleratorForeground = Color.black;
        }
        if ((acceleratorSelectionForeground = UIManager.getColor("MenuItem.acceleratorSelectionForeground")) == null) {
            acceleratorSelectionForeground = Color.black;
        }
    }

    class MouseHandler
    extends MouseAdapter {
        boolean msgSet = false;

        MouseHandler() {
        }

        public void mouseReleased(MouseEvent evt) {
            if (this.msgSet) {
                GUIUtilities.getView((Component)evt.getSource()).getStatus().setMessage(null);
                this.msgSet = false;
            }
        }

        public void mouseEntered(MouseEvent evt) {
            String msg = jEdit.getProperty(EnhancedMenuItem.this.action + ".mouse-over");
            if (msg != null) {
                GUIUtilities.getView((Component)evt.getSource()).getStatus().setMessage(msg);
                this.msgSet = true;
            }
        }

        public void mouseExited(MouseEvent evt) {
            if (this.msgSet) {
                GUIUtilities.getView((Component)evt.getSource()).getStatus().setMessage(null);
                this.msgSet = false;
            }
        }
    }
}

