/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.jEdit;

public class PasteFromListDialog
extends EnhancedDialog {
    private View view;
    private JList clips;
    private JTextArea clipText;
    private JButton insert;
    private JButton cancel;

    public PasteFromListDialog(String name, View view, ListModel model) {
        super(view, jEdit.getProperty(name + ".title"), true);
        this.view = view;
        JPanel content = new JPanel(new BorderLayout());
        content.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(content);
        JPanel center = new JPanel(new GridLayout(2, 1, 2, 12));
        this.clips = new JList(model);
        this.clips.setCellRenderer(new Renderer());
        this.clips.setVisibleRowCount(12);
        this.clips.addMouseListener(new MouseHandler());
        this.clips.addListSelectionListener(new ListHandler());
        this.insert = new JButton(jEdit.getProperty("common.insert"));
        this.cancel = new JButton(jEdit.getProperty("common.cancel"));
        JLabel label = new JLabel(jEdit.getProperty(name + ".caption"));
        label.setBorder(new EmptyBorder(0, 0, 6, 0));
        content.add("North", label);
        JScrollPane scroller = new JScrollPane(this.clips);
        scroller.setPreferredSize(new Dimension(500, 150));
        center.add(scroller);
        this.clipText = new JTextArea();
        this.clipText.setEditable(false);
        scroller = new JScrollPane(this.clipText);
        scroller.setPreferredSize(new Dimension(500, 150));
        center.add(scroller);
        content.add((Component)center, "Center");
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.setBorder(new EmptyBorder(12, 0, 0, 0));
        panel.add(Box.createGlue());
        panel.add(this.insert);
        panel.add(Box.createHorizontalStrut(6));
        panel.add(this.cancel);
        panel.add(Box.createGlue());
        content.add((Component)panel, "South");
        if (model.getSize() >= 1) {
            this.clips.setSelectedIndex(0);
        }
        this.updateButtons();
        this.getRootPane().setDefaultButton(this.insert);
        this.insert.addActionListener(new ActionHandler());
        this.cancel.addActionListener(new ActionHandler());
        GUIUtilities.requestFocus(this, this.clips);
        this.pack();
        this.setLocationRelativeTo(view);
        this.setVisible(true);
    }

    public void ok() {
        Object[] selected = this.clips.getSelectedValues();
        if (selected == null || selected.length == 0) {
            this.getToolkit().beep();
            return;
        }
        this.view.getTextArea().setSelectedText(this.getSelectedClipText());
        this.dispose();
    }

    public void cancel() {
        this.dispose();
    }

    private String getSelectedClipText() {
        Object[] selected = this.clips.getSelectedValues();
        StringBuffer clip = new StringBuffer();
        for (int i = 0; i < selected.length; ++i) {
            if (i != 0) {
                clip.append('\n');
            }
            clip.append(selected[i]);
        }
        return clip.toString();
    }

    private void updateButtons() {
        int selected = this.clips.getSelectedIndex();
        this.insert.setEnabled(selected != -1);
    }

    private void showClipText() {
        Object[] selected = this.clips.getSelectedValues();
        if (selected == null || selected.length == 0) {
            this.clipText.setText("");
        } else {
            this.clipText.setText(this.getSelectedClipText());
        }
        this.clipText.setCaretPosition(0);
    }

    class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        public void mouseClicked(MouseEvent evt) {
            if (evt.getClickCount() == 2) {
                PasteFromListDialog.this.ok();
            }
        }
    }

    class ListHandler
    implements ListSelectionListener {
        ListHandler() {
        }

        public void valueChanged(ListSelectionEvent evt) {
            PasteFromListDialog.this.showClipText();
            PasteFromListDialog.this.updateButtons();
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            if (source == PasteFromListDialog.this.insert) {
                PasteFromListDialog.this.ok();
            } else if (source == PasteFromListDialog.this.cancel) {
                PasteFromListDialog.this.cancel();
            }
        }
    }

    class Renderer
    extends DefaultListCellRenderer {
        Renderer() {
        }

        String shorten(String item) {
            StringBuffer buf = new StringBuffer();
            if (item.toLowerCase().startsWith("<html>")) {
                buf.append(' ');
            }
            boolean ws = true;
            for (int i = 0; i < item.length(); ++i) {
                char ch = item.charAt(i);
                if (Character.isWhitespace(ch)) {
                    if (ws) continue;
                    buf.append(' ');
                    ws = true;
                    continue;
                }
                ws = false;
                buf.append(ch);
            }
            if (buf.length() == 0) {
                return jEdit.getProperty("paste-from-list.whitespace");
            }
            return buf.toString();
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            this.setText(this.shorten(value.toString()));
            return this;
        }
    }
}

