/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.TextUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.KeyEventWorkaround;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.syntax.KeywordMap;
import org.gjt.sp.jedit.textarea.JEditTextArea;

public class CompleteWord
extends JWindow {
    private View view;
    private JEditTextArea textArea;
    private Buffer buffer;
    private String word;
    private JList words;
    private String noWordSep;

    public static void completeWord(View view) {
        JEditTextArea textArea = view.getTextArea();
        Buffer buffer = view.getBuffer();
        int caretLine = textArea.getCaretLine();
        int caret = textArea.getCaretPosition();
        if (!buffer.isEditable()) {
            textArea.getToolkit().beep();
            return;
        }
        KeywordMap keywordMap = buffer.getKeywordMapAtOffset(caret);
        String noWordSep = CompleteWord.getNonAlphaNumericWordChars(buffer, keywordMap);
        String word = CompleteWord.getWordToComplete(buffer, caretLine, caret, noWordSep);
        if (word == null) {
            textArea.getToolkit().beep();
            return;
        }
        Object[] completions = CompleteWord.getCompletions(buffer, word, caret);
        if (completions.length == 0) {
            textArea.getToolkit().beep();
        } else if (completions.length == 1) {
            Completion c = completions[0];
            if (c.text.equals(word)) {
                textArea.getToolkit().beep();
            } else {
                textArea.setSelectedText(c.text.substring(word.length()));
            }
        } else {
            String longestPrefix = MiscUtilities.getLongestPrefix(completions, keywordMap != null ? keywordMap.getIgnoreCase() : false);
            if (word.length() < longestPrefix.length()) {
                buffer.insert(caret, longestPrefix.substring(word.length()));
            }
            textArea.scrollToCaret(false);
            Point location = textArea.offsetToXY(caret - word.length());
            location.y += textArea.getPainter().getFontMetrics().getHeight();
            SwingUtilities.convertPointToScreen(location, textArea.getPainter());
            new CompleteWord(view, longestPrefix, (Completion[])completions, location, noWordSep);
        }
    }

    public CompleteWord(View view, String word, Completion[] completions, Point location, String noWordSep) {
        super(view);
        this.noWordSep = noWordSep;
        this.setContentPane(new JPanel(new BorderLayout()){

            public boolean isManagingFocus() {
                return false;
            }

            public boolean getFocusTraversalKeysEnabled() {
                return false;
            }
        });
        this.view = view;
        this.textArea = view.getTextArea();
        this.buffer = view.getBuffer();
        this.word = word;
        this.words = new JList<Completion>(completions);
        this.words.setVisibleRowCount(Math.min(completions.length, 8));
        this.words.addMouseListener(new MouseHandler());
        this.words.setSelectedIndex(0);
        this.words.setSelectionMode(0);
        this.words.setCellRenderer(new Renderer());
        JScrollPane scroller = new JScrollPane(this.words, 22, 31);
        this.getContentPane().add((Component)scroller, "Center");
        GUIUtilities.requestFocus(this, this.words);
        this.pack();
        this.setLocation(location);
        this.setVisible(true);
        KeyHandler keyHandler = new KeyHandler();
        this.addKeyListener(keyHandler);
        this.words.addKeyListener(keyHandler);
        view.setKeyEventInterceptor(keyHandler);
    }

    public void dispose() {
        this.view.setKeyEventInterceptor(null);
        super.dispose();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CompleteWord.this.textArea.requestFocus();
            }
        });
    }

    private static String getNonAlphaNumericWordChars(Buffer buffer, KeywordMap keywordMap) {
        String keywordNoWordSep;
        String noWordSep = buffer.getStringProperty("noWordSep");
        if (noWordSep == null) {
            noWordSep = "";
        }
        if (keywordMap != null && (keywordNoWordSep = keywordMap.getNonAlphaNumericChars()) != null) {
            noWordSep = noWordSep + keywordNoWordSep;
        }
        return noWordSep;
    }

    private static String getWordToComplete(Buffer buffer, int caretLine, int caret, String noWordSep) {
        String line = buffer.getLineText(caretLine);
        int dot = caret - buffer.getLineStartOffset(caretLine);
        if (dot == 0) {
            return null;
        }
        char ch = line.charAt(dot - 1);
        if (!Character.isLetterOrDigit(ch) && noWordSep.indexOf(ch) == -1) {
            return null;
        }
        int wordStart = TextUtilities.findWordStart(line, dot - 1, noWordSep);
        String word = line.substring(wordStart, dot);
        if (word.length() == 0) {
            return null;
        }
        return word;
    }

    private static Completion[] getCompletions(Buffer buffer, String word, int caret) {
        TreeSet completions = new TreeSet(new MiscUtilities.StringCompare());
        HashSet<Buffer> buffers = new HashSet<Buffer>();
        KeywordMap keywordMap = buffer.getKeywordMapAtOffset(caret);
        String noWordSep = CompleteWord.getNonAlphaNumericWordChars(buffer, keywordMap);
        for (View views = jEdit.getFirstView(); views != null; views = views.getNext()) {
            EditPane[] panes = views.getEditPanes();
            for (int i = 0; i < panes.length; ++i) {
                Buffer b = panes[i].getBuffer();
                if (buffers.contains(b)) continue;
                buffers.add(b);
                KeywordMap _keywordMap = b == buffer ? keywordMap : null;
                int offset = b == buffer ? caret : 0;
                CompleteWord.getCompletions(b, word, keywordMap, noWordSep, offset, completions);
            }
        }
        Completion[] completionArray = completions.toArray(new Completion[completions.size()]);
        return completionArray;
    }

    private static void getCompletions(Buffer buffer, String word, KeywordMap keywordMap, String noWordSep, int caret, Set completions) {
        int wordLen = word.length();
        if (keywordMap != null) {
            String[] keywords = keywordMap.getKeywords();
            for (int i = 0; i < keywords.length; ++i) {
                Completion keyword;
                String _keyword = keywords[i];
                if (!_keyword.regionMatches(keywordMap.getIgnoreCase(), 0, word, 0, wordLen) || completions.contains(keyword = new Completion(_keyword, true))) continue;
                completions.add(keyword);
            }
        }
        for (int i = 0; i < buffer.getLineCount(); ++i) {
            String _word;
            Completion comp;
            String line = buffer.getLineText(i);
            int start = buffer.getLineStartOffset(i);
            if (line.startsWith(word) && caret != start + word.length() && !completions.contains(comp = new Completion(_word = CompleteWord.completeWord(line, 0, noWordSep), false))) {
                completions.add(comp);
            }
            int len = line.length() - word.length();
            for (int j = 0; j < len; ++j) {
                String _word2;
                Completion comp2;
                char c = line.charAt(j);
                if (Character.isLetterOrDigit(c) || noWordSep.indexOf(c) != -1 || !line.regionMatches(j + 1, word, 0, wordLen) || caret == start + j + word.length() + 1 || completions.contains(comp2 = new Completion(_word2 = CompleteWord.completeWord(line, j + 1, noWordSep), false))) continue;
                completions.add(comp2);
            }
        }
    }

    private static String completeWord(String line, int offset, String noWordSep) {
        int wordEnd = TextUtilities.findWordEnd(line, offset + 1, noWordSep);
        return line.substring(offset, wordEnd);
    }

    private void insertSelected() {
        this.textArea.setSelectedText(this.words.getSelectedValue().toString().substring(this.word.length()));
        this.dispose();
    }

    class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        public void mouseClicked(MouseEvent evt) {
            CompleteWord.this.insertSelected();
        }
    }

    class KeyHandler
    extends KeyAdapter {
        KeyHandler() {
        }

        public void keyPressed(KeyEvent evt) {
            switch (evt.getKeyCode()) {
                case 9: 
                case 10: {
                    CompleteWord.this.insertSelected();
                    evt.consume();
                    break;
                }
                case 27: {
                    CompleteWord.this.dispose();
                    evt.consume();
                    break;
                }
                case 38: {
                    int selected = CompleteWord.this.words.getSelectedIndex();
                    if (selected == 0) {
                        selected = CompleteWord.this.words.getModel().getSize() - 1;
                    } else {
                        if (CompleteWord.this.getFocusOwner() == CompleteWord.this.words) {
                            return;
                        }
                        --selected;
                    }
                    CompleteWord.this.words.setSelectedIndex(selected);
                    CompleteWord.this.words.ensureIndexIsVisible(selected);
                    evt.consume();
                    break;
                }
                case 40: {
                    int selected = CompleteWord.this.words.getSelectedIndex();
                    if (selected == CompleteWord.this.words.getModel().getSize() - 1) {
                        selected = 0;
                    } else {
                        if (CompleteWord.this.getFocusOwner() == CompleteWord.this.words) {
                            return;
                        }
                        ++selected;
                    }
                    CompleteWord.this.words.setSelectedIndex(selected);
                    CompleteWord.this.words.ensureIndexIsVisible(selected);
                    evt.consume();
                    break;
                }
                case 8: {
                    if (CompleteWord.this.word.length() == 1) {
                        CompleteWord.this.textArea.backspace();
                        evt.consume();
                        CompleteWord.this.dispose();
                        break;
                    }
                    CompleteWord.this.word = CompleteWord.this.word.substring(0, CompleteWord.this.word.length() - 1);
                    CompleteWord.this.textArea.backspace();
                    int caret = CompleteWord.this.textArea.getCaretPosition();
                    Completion[] completions = CompleteWord.getCompletions(CompleteWord.this.buffer, CompleteWord.this.word, caret);
                    if (completions.length == 0) {
                        CompleteWord.this.dispose();
                        return;
                    }
                    CompleteWord.this.words.setListData(completions);
                    CompleteWord.this.words.setSelectedIndex(0);
                    CompleteWord.this.words.setVisibleRowCount(Math.min(completions.length, 8));
                    CompleteWord.this.pack();
                    evt.consume();
                    break;
                }
                default: {
                    if (!evt.isActionKey() && !evt.isControlDown() && !evt.isAltDown() && !evt.isMetaDown()) break;
                    CompleteWord.this.dispose();
                    CompleteWord.this.view.processKeyEvent(evt);
                }
            }
        }

        public void keyTyped(KeyEvent evt) {
            char ch = evt.getKeyChar();
            if ((evt = KeyEventWorkaround.processKeyEvent(evt)) == null) {
                return;
            }
            if (Character.isDigit(ch)) {
                int index = ch - 48;
                index = index == 0 ? 9 : --index;
                if (index < CompleteWord.this.words.getModel().getSize()) {
                    CompleteWord.this.words.setSelectedIndex(index);
                    CompleteWord.this.textArea.setSelectedText(CompleteWord.this.words.getModel().getElementAt(index).toString().substring(CompleteWord.this.word.length()));
                    CompleteWord.this.dispose();
                    return;
                }
            }
            if (ch != '\b' && ch != '\t') {
                if (!Character.isLetterOrDigit(ch) && CompleteWord.this.noWordSep.indexOf(ch) == -1) {
                    CompleteWord.this.insertSelected();
                    CompleteWord.this.textArea.userInput(ch);
                    CompleteWord.this.dispose();
                    return;
                }
                CompleteWord.this.textArea.userInput(ch);
                CompleteWord.this.word = CompleteWord.this.word + ch;
                int caret = CompleteWord.this.textArea.getCaretPosition();
                Completion[] completions = CompleteWord.getCompletions(CompleteWord.this.buffer, CompleteWord.this.word, caret);
                if (completions.length == 0) {
                    CompleteWord.this.dispose();
                    return;
                }
                CompleteWord.this.words.setListData(completions);
                CompleteWord.this.words.setSelectedIndex(0);
                CompleteWord.this.words.setVisibleRowCount(Math.min(completions.length, 8));
            }
        }
    }

    static class Renderer
    extends DefaultListCellRenderer {
        Renderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, (Object)null, index, isSelected, cellHasFocus);
            Completion comp = (Completion)value;
            if (index < 9) {
                this.setText(index + 1 + ": " + comp.text);
            } else if (index == 9) {
                this.setText("0: " + comp.text);
            } else {
                this.setText(comp.text);
            }
            if (comp.keyword) {
                this.setFont(list.getFont().deriveFont(1));
            } else {
                this.setFont(list.getFont());
            }
            return this;
        }
    }

    static class Completion {
        String text;
        boolean keyword;

        Completion(String text, boolean keyword) {
            this.text = text;
            this.keyword = keyword;
        }

        public String toString() {
            return this.text;
        }

        public int hashCode() {
            return this.text.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Completion) {
                return ((Completion)obj).text.equals(this.text);
            }
            return false;
        }
    }
}

