/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import bsh.NameSpace;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.gjt.sp.jedit.BeanShell;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.Macros;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.HistoryTextField;
import org.gjt.sp.jedit.gui.KeyEventWorkaround;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.jEdit;

public class ActionBar
extends JPanel {
    private static NameSpace namespace = new NameSpace(BeanShell.getNameSpace(), "action bar namespace");
    private View view;
    private boolean temp;
    private int repeatCount;
    private HistoryTextField action;
    private CompletionPopup popup;
    private RolloverButton close;

    public ActionBar(View view, boolean temp) {
        this.setLayout(new BoxLayout(this, 0));
        this.view = view;
        this.temp = temp;
        this.add(Box.createHorizontalStrut(2));
        JLabel label = new JLabel(jEdit.getProperty("view.action.prompt"));
        this.add(label);
        this.add(Box.createHorizontalStrut(12));
        this.action = new ActionTextField();
        this.add(this.action);
        this.action.setEnterAddsToHistory(false);
        Dimension max = this.action.getPreferredSize();
        max.width = Integer.MAX_VALUE;
        this.action.setMaximumSize(max);
        this.action.addActionListener(new ActionHandler());
        this.action.getDocument().addDocumentListener(new DocumentHandler());
        if (temp) {
            this.close = new RolloverButton(GUIUtilities.loadIcon("closebox.gif"));
            this.close.addActionListener(new ActionHandler());
            this.close.setToolTipText(jEdit.getProperty("view.action.close-tooltip"));
            this.add(this.close);
        }
        this.temp = temp;
    }

    public HistoryTextField getField() {
        return this.action;
    }

    public void goToActionBar() {
        this.repeatCount = this.view.getInputHandler().getRepeatCount();
        this.action.setText(null);
        this.action.requestFocus();
    }

    private void invoke() {
        String finalCmd;
        EditAction act;
        String cmd;
        if (this.popup != null) {
            cmd = this.popup.list.getSelectedValue().toString();
        } else {
            cmd = this.action.getText().trim();
            int index = cmd.indexOf(61);
            if (index != -1) {
                String code;
                this.action.addCurrentToHistory();
                String propName = cmd.substring(0, index).trim();
                String propValue = cmd.substring(index + 1).trim();
                if (propName.startsWith("buffer.")) {
                    code = propName.equals("buffer.mode") ? "buffer.setMode(\"" + MiscUtilities.charsToEscapes(propValue) + "\");" : "buffer.setStringProperty(\"" + MiscUtilities.charsToEscapes(propName.substring("buffer.".length())) + "\",\"" + MiscUtilities.charsToEscapes(propValue) + "\");";
                    code = code + "\nbuffer.propertiesChanged();";
                } else {
                    code = propName.startsWith("!buffer.") ? "jEdit.setProperty(\"" + MiscUtilities.charsToEscapes(propName.substring(1)) + "\",\"" + MiscUtilities.charsToEscapes(propValue) + "\");\n" + "jEdit.propertiesChanged();" : "jEdit.setProperty(\"" + MiscUtilities.charsToEscapes(propName) + "\",\"" + MiscUtilities.charsToEscapes(propValue) + "\");\n" + "jEdit.propertiesChanged();";
                }
                Macros.Recorder recorder = this.view.getMacroRecorder();
                if (recorder != null) {
                    recorder.record(code);
                }
                BeanShell.eval(this.view, namespace, code);
                cmd = null;
            } else if (cmd.length() != 0) {
                String[] completions = this.getCompletions(cmd);
                if (completions.length != 0) {
                    cmd = completions[0];
                }
            } else {
                cmd = null;
            }
        }
        if (this.popup != null) {
            this.popup.dispose();
            this.popup = null;
        }
        EditAction editAction = act = (finalCmd = cmd) == null ? null : jEdit.getAction(finalCmd);
        if (this.temp) {
            this.view.removeToolBar(this);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ActionBar.this.view.getTextArea().requestFocus();
                if (act == null) {
                    if (finalCmd != null) {
                        ActionBar.this.view.getStatus().setMessageAndClear(jEdit.getProperty("view.action.no-completions"));
                    }
                } else {
                    ActionBar.this.view.getInputHandler().setRepeatCount(ActionBar.this.repeatCount);
                    ActionBar.this.view.getInputHandler().invokeAction(act);
                }
            }
        });
    }

    private String[] getCompletions(String str) {
        str = str.toLowerCase();
        String[] actions = jEdit.getActionNames();
        ArrayList<String> returnValue = new ArrayList<String>(actions.length);
        for (int i = 0; i < actions.length; ++i) {
            if (actions[i].toLowerCase().indexOf(str) == -1) continue;
            returnValue.add(actions[i]);
        }
        return returnValue.toArray(new String[returnValue.size()]);
    }

    private void complete(boolean insertLongestPrefix) {
        String text = this.action.getText().trim();
        String[] completions = this.getCompletions(text);
        if (completions.length == 1) {
            if (insertLongestPrefix) {
                this.action.setText(completions[0]);
            }
        } else if (completions.length != 0) {
            String prefix;
            if (insertLongestPrefix && (prefix = MiscUtilities.getLongestPrefix(completions, true)).indexOf(text) != -1) {
                this.action.setText(prefix);
            }
            if (this.popup != null) {
                this.popup.setModel(completions);
            } else {
                this.popup = new CompletionPopup(completions);
            }
            return;
        }
        if (this.popup != null) {
            this.popup.dispose();
            this.popup = null;
        }
    }

    class CompletionPopup
    extends JWindow {
        CompletionList list;

        CompletionPopup(String[] actions) {
            super(ActionBar.this.view);
            this.setContentPane(new JPanel(this, new BorderLayout()){
                private final /* synthetic */ CompletionPopup this$1;
                {
                    this.this$1 = this$1;
                }

                public boolean isManagingFocus() {
                    return false;
                }

                public boolean getFocusTraversalKeysEnabled() {
                    return false;
                }
            });
            this.list = new CompletionList(actions);
            this.list.setVisibleRowCount(8);
            this.list.addMouseListener(new MouseHandler());
            this.list.setSelectedIndex(0);
            this.list.setSelectionMode(0);
            JScrollPane scroller = new JScrollPane(this.list, 22, 31);
            this.getContentPane().add((Component)scroller, "Center");
            GUIUtilities.requestFocus(this, this.list);
            this.pack();
            Point p = new Point(0, -this.getHeight());
            SwingUtilities.convertPointToScreen(p, ActionBar.this.action);
            this.setLocation(p);
            this.setVisible(true);
            KeyHandler keyHandler = new KeyHandler();
            this.addKeyListener(keyHandler);
            this.list.addKeyListener(keyHandler);
        }

        void setModel(String[] actions) {
            this.list.setListData(actions);
            this.list.setSelectedIndex(0);
        }

        class KeyHandler
        extends KeyAdapter {
            KeyHandler() {
            }

            public void keyTyped(KeyEvent evt) {
                ActionBar.this.action.processKeyEvent(evt);
            }

            public void keyPressed(KeyEvent evt) {
                int selected;
                int keyCode = evt.getKeyCode();
                if (keyCode == 27) {
                    ActionBar.this.action.processKeyEvent(evt);
                } else if (keyCode == 10) {
                    ActionBar.this.invoke();
                } else if (keyCode == 38) {
                    int selected2 = CompletionPopup.this.list.getSelectedIndex();
                    if (selected2 == 0) {
                        CompletionPopup.this.list.setSelectedIndex(CompletionPopup.this.list.getModel().getSize() - 1);
                        evt.consume();
                    }
                } else if (keyCode == 40 && (selected = CompletionPopup.this.list.getSelectedIndex()) == CompletionPopup.this.list.getModel().getSize() - 1) {
                    CompletionPopup.this.list.setSelectedIndex(0);
                    evt.consume();
                }
            }
        }

        class CompletionList
        extends JList {
            CompletionList(Object[] data) {
                super(data);
            }

            public void processKeyEvent(KeyEvent evt) {
                super.processKeyEvent(evt);
            }
        }

        class MouseHandler
        extends MouseAdapter {
            MouseHandler() {
            }

            public void mouseClicked(MouseEvent evt) {
                ActionBar.this.invoke();
            }
        }
    }

    class ActionTextField
    extends HistoryTextField {
        boolean repeat;
        boolean nonDigit;

        ActionTextField() {
            super("action");
            this.setSelectAllOnFocus(true);
        }

        public boolean isManagingFocus() {
            return false;
        }

        public boolean getFocusTraversalKeysEnabled() {
            return false;
        }

        public void processKeyEvent(KeyEvent evt) {
            if ((evt = KeyEventWorkaround.processKeyEvent(evt)) == null) {
                return;
            }
            switch (evt.getID()) {
                case 400: {
                    char ch = evt.getKeyChar();
                    if (!this.nonDigit && Character.isDigit(ch)) {
                        super.processKeyEvent(evt);
                        this.repeat = true;
                        ActionBar.this.repeatCount = Integer.parseInt(ActionBar.this.action.getText());
                        break;
                    }
                    this.nonDigit = true;
                    if (this.repeat) {
                        this.passToView(evt);
                        break;
                    }
                    super.processKeyEvent(evt);
                    break;
                }
                case 401: {
                    int keyCode = evt.getKeyCode();
                    if (evt.isActionKey() || evt.isControlDown() || evt.isAltDown() || evt.isMetaDown() || keyCode == 8 || keyCode == 127 || keyCode == 10 || keyCode == 9 || keyCode == 27) {
                        this.nonDigit = true;
                        if (this.repeat) {
                            this.passToView(evt);
                            break;
                        }
                        if (keyCode == 9) {
                            ActionBar.this.complete(true);
                            evt.consume();
                        } else {
                            if (keyCode == 27) {
                                evt.consume();
                                if (ActionBar.this.popup != null) {
                                    ActionBar.this.popup.dispose();
                                    ActionBar.this.popup = null;
                                    ActionBar.this.action.requestFocus();
                                    break;
                                }
                                if (ActionBar.this.temp) {
                                    ActionBar.this.view.removeToolBar(ActionBar.this);
                                }
                                ActionBar.this.view.getEditPane().focusOnTextArea();
                                break;
                            }
                            if ((keyCode == 38 || keyCode == 40) && ActionBar.this.popup != null) {
                                ((ActionBar)ActionBar.this).popup.list.processKeyEvent(evt);
                                break;
                            }
                        }
                    }
                    super.processKeyEvent(evt);
                }
            }
        }

        private void passToView(KeyEvent evt) {
            if (ActionBar.this.temp) {
                ActionBar.this.view.removeToolBar(ActionBar.this);
            }
            ActionBar.this.view.getTextArea().requestFocus();
            SwingUtilities.invokeLater(new Runnable(this, evt){
                private final /* synthetic */ KeyEvent val$evt;
                private final /* synthetic */ ActionTextField this$1;
                {
                    this.this$1 = this$1;
                    this.val$evt = val$evt;
                }

                public void run() {
                    ActionBar.access$000(ActionTextField.access$800(this.this$1)).getTextArea().requestFocus();
                    ActionBar.access$000(ActionTextField.access$800(this.this$1)).getInputHandler().setRepeatCount(ActionBar.access$100(ActionTextField.access$800(this.this$1)));
                    ActionBar.access$000(ActionTextField.access$800(this.this$1)).processKeyEvent(this.val$evt, 2);
                }
            });
        }

        public void addNotify() {
            super.addNotify();
            this.nonDigit = false;
            this.repeat = false;
        }

        static /* synthetic */ ActionBar access$800(ActionTextField x0) {
            return x0.ActionBar.this;
        }
    }

    class DocumentHandler
    implements DocumentListener {
        DocumentHandler() {
        }

        public void insertUpdate(DocumentEvent evt) {
            if (ActionBar.this.popup != null) {
                ActionBar.this.complete(false);
            }
        }

        public void removeUpdate(DocumentEvent evt) {
            if (ActionBar.this.popup != null) {
                ActionBar.this.complete(false);
            }
        }

        public void changedUpdate(DocumentEvent evt) {
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == ActionBar.this.close) {
                ActionBar.this.view.removeToolBar(ActionBar.this);
            } else {
                ActionBar.this.invoke();
            }
        }
    }
}

