/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.browser;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.browser.BrowserView;
import org.gjt.sp.jedit.browser.VFSBrowser;
import org.gjt.sp.jedit.gui.HistoryTextField;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSManager;

class VFSFileNameField
extends HistoryTextField {
    private VFSBrowser browser;

    VFSFileNameField(VFSBrowser browser, String model) {
        super(model);
        this.setEnterAddsToHistory(false);
        this.browser = browser;
        Dimension dim = this.getPreferredSize();
        dim.width = Integer.MAX_VALUE;
        this.setMaximumSize(dim);
        ActionMap map = this.getActionMap();
        Action backspace = map.get("delete-previous");
        map.put("delete-previous", new BackspaceAction(backspace));
    }

    public boolean isManagingFocus() {
        return false;
    }

    public boolean getFocusTraversalKeysEnabled() {
        return false;
    }

    public void processKeyEvent(KeyEvent evt) {
        if (evt.getID() == 401) {
            String path = this.getText();
            switch (evt.getKeyCode()) {
                case 9: {
                    this.doComplete(path);
                    break;
                }
                case 37: {
                    if (this.getCaretPosition() == 0) {
                        this.browser.getBrowserView().getTable().processKeyEvent(evt);
                        break;
                    }
                    super.processKeyEvent(evt);
                    break;
                }
                case 39: {
                    if (this.getCaretPosition() == this.getDocument().getLength()) {
                        this.browser.getBrowserView().getTable().processKeyEvent(evt);
                        break;
                    }
                    super.processKeyEvent(evt);
                    break;
                }
                case 33: 
                case 34: 
                case 38: 
                case 40: {
                    this.browser.getBrowserView().getTable().processKeyEvent(evt);
                    break;
                }
                case 10: {
                    this.browser.filesActivated(evt.isShiftDown() ? 1 : 0, false);
                    this.setText(null);
                    evt.consume();
                    break;
                }
                default: {
                    super.processKeyEvent(evt);
                    break;
                }
            }
        } else if (evt.getID() == 400) {
            char ch = evt.getKeyChar();
            if ((ch == '/' || ch == File.separatorChar) && this.getCaretPosition() == this.getDocument().getLength()) {
                VFS vfs;
                super.processKeyEvent(evt);
                String path = this.getText();
                if (path.length() == 2 && path.charAt(0) == '-') {
                    path = this.browser.getView().getBuffer().getDirectory();
                } else if (path.length() == 3 && path.startsWith("..")) {
                    path = MiscUtilities.getParentOfPath(this.browser.getDirectory());
                    vfs = VFSManager.getVFSForPath(path);
                    if ((vfs.getCapabilities() & 0x40) != 0) {
                        this.browser.setDirectory(path);
                        VFSManager.waitForRequests();
                        this.setText(null);
                    }
                } else if (!MiscUtilities.isAbsolutePath(path)) {
                    VFS.DirectoryEntry[] files = this.browser.getBrowserView().getSelectedFiles();
                    if (files.length != 1 || files[0].type == 0) {
                        return;
                    }
                    path = files[0].path;
                } else if (OperatingSystem.isDOSDerived() && path.length() == 3 && path.charAt(1) == ':') {
                    this.browser.setDirectory(path);
                    VFSManager.waitForRequests();
                    this.setText(null);
                }
                vfs = VFSManager.getVFSForPath(path);
                if ((vfs.getCapabilities() & 0x40) != 0) {
                    this.setText(null);
                    this.browser.setDirectory(path);
                    VFSManager.waitForRequests();
                } else if (path.endsWith("/") || path.endsWith(File.separator)) {
                    this.setText(path);
                } else {
                    this.setText(path + vfs.getFileSeparator());
                }
            } else if (ch > ' ' && ch != '\u007f' && ch != '\u00ff') {
                super.processKeyEvent(evt);
                String path = this.getText();
                BrowserView view = this.browser.getBrowserView();
                view.selectNone();
                int mode = this.browser.getMode();
                view.getTable().doTypeSelect(path, mode == 3 || mode == 1);
            } else {
                super.processKeyEvent(evt);
            }
        }
    }

    private void doComplete(String currentText) {
        BrowserView view = this.browser.getBrowserView();
        view.selectNone();
        view.getTable().doTypeSelect(currentText, this.browser.getMode() == 3);
        VFS.DirectoryEntry[] files = view.getSelectedFiles();
        if (files.length == 0) {
            return;
        }
        String path = files[0].path;
        String name = files[0].name;
        String parent = MiscUtilities.getParentOfPath(path);
        String newText = MiscUtilities.isAbsolutePath(currentText) && !currentText.startsWith(this.browser.getDirectory()) ? path : (VFSBrowser.pathsEqual(parent, this.browser.getDirectory()) ? name : path);
        this.setText(newText);
    }

    private void goToParent() {
        String name = MiscUtilities.getFileName(this.browser.getDirectory());
        String parent = MiscUtilities.getParentOfPath(this.browser.getDirectory());
        this.browser.setDirectory(parent);
        VFS vfs = VFSManager.getVFSForPath(parent);
        if ((vfs.getCapabilities() & 0x40) != 0) {
            VFSManager.waitForRequests();
            this.setText(name);
            this.browser.getBrowserView().getTable().doTypeSelect(name, this.browser.getMode() == 3);
        }
    }

    class BackspaceAction
    extends AbstractAction {
        private Action delegate;

        BackspaceAction(Action delegate) {
            this.delegate = delegate;
        }

        public void actionPerformed(ActionEvent evt) {
            if (VFSFileNameField.this.getSelectionStart() == 0 && VFSFileNameField.this.getSelectionEnd() == 0) {
                VFSFileNameField.this.goToParent();
            } else {
                this.delegate.actionPerformed(evt);
                String path = VFSFileNameField.this.getText();
                BrowserView view = VFSFileNameField.this.browser.getBrowserView();
                view.selectNone();
                int mode = VFSFileNameField.this.browser.getMode();
                view.getTable().doTypeSelect(path, mode == 3 || mode == 1);
            }
        }
    }
}

