/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import bsh.BshClassManager;
import bsh.BshMethod;
import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.NameSpace;
import bsh.Primitive;
import bsh.TargetError;
import bsh.UtilEvalError;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.LinkedList;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.JARClassLoader;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.BeanShellErrorDialog;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.util.Log;

public class BeanShell {
    private static final String REQUIRED_VERSION = "2.0b1.1-jedit-1";
    private static final Object[] NO_ARGS = new Object[0];
    private static CustomClassManager classManager;
    private static Interpreter interpForMethods;
    private static NameSpace global;
    private static boolean running;
    static /* synthetic */ Class class$org$gjt$sp$jedit$BeanShell;
    static /* synthetic */ Class class$bsh$NameSpace;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Class;

    public static void evalSelection(View view, JEditTextArea textArea) {
        String command = textArea.getSelectedText();
        if (command == null) {
            view.getToolkit().beep();
            return;
        }
        Object returnValue = BeanShell.eval(view, global, command);
        if (returnValue != null) {
            textArea.setSelectedText(returnValue.toString());
        }
    }

    public static void showEvaluateDialog(View view) {
        String command = GUIUtilities.input(view, "beanshell-eval-input", null);
        if (command != null) {
            if (!command.endsWith(";")) {
                command = command + ";";
            }
            int repeat = view.getInputHandler().getRepeatCount();
            if (view.getMacroRecorder() != null) {
                view.getMacroRecorder().record(repeat, command);
            }
            Object returnValue = null;
            try {
                for (int i = 0; i < repeat; ++i) {
                    returnValue = BeanShell._eval(view, global, command);
                }
            }
            catch (Throwable e) {
                Log.log(9, class$org$gjt$sp$jedit$BeanShell == null ? (class$org$gjt$sp$jedit$BeanShell = BeanShell.class$("org.gjt.sp.jedit.BeanShell")) : class$org$gjt$sp$jedit$BeanShell, e);
                BeanShell.handleException(view, null, e);
            }
            if (returnValue != null) {
                Object[] args = new String[]{returnValue.toString()};
                GUIUtilities.message(view, "beanshell-eval", args);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showEvaluateLinesDialog(View view) {
        String command = GUIUtilities.input(view, "beanshell-eval-line", null);
        JEditTextArea textArea = view.getTextArea();
        Buffer buffer = view.getBuffer();
        if (command == null || command.length() == 0) {
            return;
        }
        Selection[] selection = textArea.getSelection();
        if (selection.length == 0) {
            view.getToolkit().beep();
            return;
        }
        if (!command.endsWith(";")) {
            command = command + ";";
        }
        String script = "int[] lines = textArea.getSelectedLines();\nfor(int i = 0; i < lines.length; i++)\n{\nline = lines[i];\nindex = line - lines[0];\nstart = buffer.getLineStartOffset(line);\nend = buffer.getLineEndOffset(line);\ntext = buffer.getText(start,end - start - 1);\nnewText = " + command + "\n" + "if(newText != null)\n" + "{\n" + "buffer.remove(start,end - start - 1);\n" + "buffer.insert(start,String.valueOf(newText));\n" + "}\n" + "}\n";
        if (view.getMacroRecorder() != null) {
            view.getMacroRecorder().record(1, script);
        }
        try {
            buffer.beginCompoundEdit();
            BeanShell.eval(view, global, script);
        }
        finally {
            buffer.endCompoundEdit();
        }
        textArea.selectNone();
    }

    public static void runScript(View view, String path, Reader in, boolean ownNamespace) {
        try {
            BeanShell._runScript(view, path, in, ownNamespace);
        }
        catch (Throwable e) {
            Log.log(9, class$org$gjt$sp$jedit$BeanShell == null ? (class$org$gjt$sp$jedit$BeanShell = BeanShell.class$("org.gjt.sp.jedit.BeanShell")) : class$org$gjt$sp$jedit$BeanShell, e);
            BeanShell.handleException(view, path, e);
        }
    }

    public static void runScript(View view, String path, Reader in, NameSpace namespace) {
        try {
            BeanShell._runScript(view, path, in, namespace);
        }
        catch (Throwable e) {
            Log.log(9, class$org$gjt$sp$jedit$BeanShell == null ? (class$org$gjt$sp$jedit$BeanShell = BeanShell.class$("org.gjt.sp.jedit.BeanShell")) : class$org$gjt$sp$jedit$BeanShell, e);
            BeanShell.handleException(view, path, e);
        }
    }

    public static void _runScript(View view, String path, Reader in, boolean ownNamespace) throws Exception {
        BeanShell._runScript(view, path, in, ownNamespace ? new NameSpace(global, "script namespace") : global);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void _runScript(View view, String path, Reader in, NameSpace namespace) throws Exception {
        block28: {
            block25: {
                block23: {
                    block24: {
                        Log.log(3, BeanShell.class$org$gjt$sp$jedit$BeanShell == null ? (BeanShell.class$org$gjt$sp$jedit$BeanShell = BeanShell.class$("org.gjt.sp.jedit.BeanShell")) : BeanShell.class$org$gjt$sp$jedit$BeanShell, "Running script " + path);
                        interp = BeanShell.createInterpreter(namespace);
                        vfs = null;
                        session = null;
                        try {
                            try {
                                if (in == null) {
                                    buffer = jEdit.getBuffer(path);
                                    vfs = VFSManager.getVFSForPath(path);
                                    session = vfs.createVFSSession(path, view);
                                    if (session == null) {
                                        var9_9 = null;
                                        BeanShell.running = false;
                                        if (session == null) break block23;
                                        break block24;
                                    }
                                    if (buffer != null) {
                                        if (!buffer.isLoaded()) {
                                            VFSManager.waitForRequests();
                                        }
                                        in = new StringReader(buffer.getText(0, buffer.getLength()));
                                    } else {
                                        in = new BufferedReader(new InputStreamReader(vfs._createInputStream(session, path, false, view)));
                                    }
                                }
                                BeanShell.setupDefaultVariables(namespace, view);
                                interp.set("scriptPath", path);
                                BeanShell.running = true;
                                interp.eval(in, namespace, path);
                                break block25;
                            }
                            catch (Exception e) {
                                BeanShell.unwrapException(e);
                                var9_11 = null;
                                BeanShell.running = false;
                                if (session != null) {
                                    try {
                                        vfs._endVFSSession(session, view);
                                    }
                                    catch (IOException io) {
                                        Log.log(9, BeanShell.class$org$gjt$sp$jedit$BeanShell == null ? (BeanShell.class$org$gjt$sp$jedit$BeanShell = BeanShell.class$("org.gjt.sp.jedit.BeanShell")) : BeanShell.class$org$gjt$sp$jedit$BeanShell, io);
                                        GUIUtilities.error(view, "read-error", new String[]{path, io.toString()});
                                    }
                                }
                                try {
                                    if (namespace != BeanShell.global) return;
                                    BeanShell.resetDefaultVariables(namespace);
                                    interp.unset("scriptPath");
                                    return;
                                }
                                catch (EvalError e) {
                                    return;
                                }
                            }
                        }
                        catch (Throwable var8_17) {
                            block27: {
                                var9_12 = null;
                                BeanShell.running = false;
                                if (session != null) {
                                    ** try [egrp 2[TRYBLOCK] [6 : 217->228)] { 
lbl55:
                                    // 1 sources

                                    vfs._endVFSSession(session, view);
                                    break block27;
lbl57:
                                    // 1 sources

                                    catch (IOException io) {
                                        Log.log(9, BeanShell.class$org$gjt$sp$jedit$BeanShell == null ? (BeanShell.class$org$gjt$sp$jedit$BeanShell = BeanShell.class$("org.gjt.sp.jedit.BeanShell")) : BeanShell.class$org$gjt$sp$jedit$BeanShell, io);
                                        GUIUtilities.error(view, "read-error", new String[]{path, io.toString()});
                                    }
                                }
                            }
                            ** try [egrp 3[TRYBLOCK] [7 : 280->301)] { 
lbl62:
                            // 1 sources

                            if (namespace != BeanShell.global) throw var8_17;
                            BeanShell.resetDefaultVariables(namespace);
                            interp.unset("scriptPath");
                            throw var8_17;
lbl66:
                            // 1 sources

                            catch (EvalError e) {
                                // empty catch block
                            }
                            throw var8_17;
                        }
                    }
                    ** try [egrp 2[TRYBLOCK] [6 : 217->228)] { 
lbl71:
                    // 1 sources

                    vfs._endVFSSession(session, view);
                    break block23;
lbl73:
                    // 1 sources

                    catch (IOException io) {
                        Log.log(9, BeanShell.class$org$gjt$sp$jedit$BeanShell == null ? (BeanShell.class$org$gjt$sp$jedit$BeanShell = BeanShell.class$("org.gjt.sp.jedit.BeanShell")) : BeanShell.class$org$gjt$sp$jedit$BeanShell, io);
                        GUIUtilities.error(view, "read-error", new String[]{path, io.toString()});
                    }
                }
                ** try [egrp 3[TRYBLOCK] [7 : 280->301)] { 
lbl78:
                // 1 sources

                if (namespace != BeanShell.global) return;
                BeanShell.resetDefaultVariables(namespace);
                interp.unset("scriptPath");
                return;
lbl82:
                // 1 sources

                catch (EvalError e) {
                    // empty catch block
                }
                return;
            }
            var9_10 = null;
            BeanShell.running = false;
            if (session != null) {
                ** try [egrp 2[TRYBLOCK] [6 : 217->228)] { 
lbl90:
                // 1 sources

                vfs._endVFSSession(session, view);
                break block28;
lbl92:
                // 1 sources

                catch (IOException io) {
                    Log.log(9, BeanShell.class$org$gjt$sp$jedit$BeanShell == null ? (BeanShell.class$org$gjt$sp$jedit$BeanShell = BeanShell.class$("org.gjt.sp.jedit.BeanShell")) : BeanShell.class$org$gjt$sp$jedit$BeanShell, io);
                    GUIUtilities.error(view, "read-error", new String[]{path, io.toString()});
                }
            }
        }
        try {}
        catch (EvalError e) {}
        if (namespace != BeanShell.global) return;
        BeanShell.resetDefaultVariables(namespace);
        interp.unset("scriptPath");
        return;
    }

    public static Object eval(View view, NameSpace namespace, String command) {
        try {
            return BeanShell._eval(view, namespace, command);
        }
        catch (Throwable e) {
            Log.log(9, class$org$gjt$sp$jedit$BeanShell == null ? (class$org$gjt$sp$jedit$BeanShell = BeanShell.class$("org.gjt.sp.jedit.BeanShell")) : class$org$gjt$sp$jedit$BeanShell, e);
            BeanShell.handleException(view, null, e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object _eval(View view, NameSpace namespace, String command) throws Exception {
        Interpreter interp = BeanShell.createInterpreter(namespace);
        try {
            BeanShell.setupDefaultVariables(namespace, view);
            if (Debug.BEANSHELL_DEBUG) {
                Log.log(1, class$org$gjt$sp$jedit$BeanShell == null ? (class$org$gjt$sp$jedit$BeanShell = BeanShell.class$("org.gjt.sp.jedit.BeanShell")) : class$org$gjt$sp$jedit$BeanShell, command);
            }
            Object object = interp.eval(command);
            return object;
        }
        catch (Exception e) {
            BeanShell.unwrapException(e);
            Object var5_7 = null;
            return var5_7;
        }
        finally {
            try {
                BeanShell.resetDefaultVariables(namespace);
            }
            catch (UtilEvalError e) {}
        }
    }

    public static BshMethod cacheBlock(String id, String code, boolean namespace) throws Exception {
        String name = "__internal_" + id;
        if (namespace) {
            BeanShell._eval(null, global, name + "(ns) {\nthis.callstack.set(0,ns);\n" + code + "\n}");
            return global.getMethod(name, new Class[]{class$bsh$NameSpace == null ? (class$bsh$NameSpace = BeanShell.class$("bsh.NameSpace")) : class$bsh$NameSpace});
        }
        BeanShell._eval(null, global, name + "() {\n" + code + "\n}");
        return global.getMethod(name, new Class[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object runCachedBlock(BshMethod method, View view, NameSpace namespace) throws Exception {
        boolean useNamespace;
        if (namespace == null) {
            useNamespace = false;
            namespace = global;
        } else {
            useNamespace = true;
        }
        try {
            Object[] objectArray;
            BeanShell.setupDefaultVariables(namespace, view);
            if (useNamespace) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = namespace;
            } else {
                objectArray = NO_ARGS;
            }
            Object retVal = method.invoke(objectArray, interpForMethods, new CallStack());
            if (retVal instanceof Primitive) {
                if (retVal == Primitive.VOID) {
                    Object var5_6 = null;
                    return var5_6;
                }
                Object object = ((Primitive)retVal).getValue();
                return object;
            }
            Object object = retVal;
            return object;
        }
        catch (Exception e) {
            BeanShell.unwrapException(e);
            Object var5_9 = null;
            return var5_9;
        }
        finally {
            BeanShell.resetDefaultVariables(namespace);
        }
    }

    public static boolean isScriptRunning() {
        return running;
    }

    public static NameSpace getNameSpace() {
        return global;
    }

    public static void runScript(View view, String path, boolean ownNamespace, boolean rethrowBshErrors) {
        BeanShell.runScript(view, path, null, ownNamespace);
    }

    public static void runScript(View view, String path, Reader in, boolean ownNamespace, boolean rethrowBshErrors) {
        BeanShell.runScript(view, path, in, ownNamespace);
    }

    public static Object eval(View view, String command, boolean rethrowBshErrors) {
        return BeanShell.eval(view, global, command);
    }

    public static Object eval(View view, NameSpace namespace, String command, boolean rethrowBshErrors) {
        return BeanShell.eval(view, namespace, command);
    }

    static void init() {
        try {
            (class$bsh$NameSpace == null ? (class$bsh$NameSpace = BeanShell.class$("bsh.NameSpace")) : class$bsh$NameSpace).getMethod("addCommandPath", class$java$lang$String == null ? (class$java$lang$String = BeanShell.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Class == null ? (class$java$lang$Class = BeanShell.class$("java.lang.Class")) : class$java$lang$Class);
        }
        catch (Exception e) {
            Log.log(9, class$org$gjt$sp$jedit$BeanShell == null ? (class$org$gjt$sp$jedit$BeanShell = BeanShell.class$("org.gjt.sp.jedit.BeanShell")) : class$org$gjt$sp$jedit$BeanShell, "You have BeanShell version 2.0b1.1-jedit-1 in your CLASSPATH.");
            Log.log(9, class$org$gjt$sp$jedit$BeanShell == null ? (class$org$gjt$sp$jedit$BeanShell = BeanShell.class$("org.gjt.sp.jedit.BeanShell")) : class$org$gjt$sp$jedit$BeanShell, "Please remove it from the CLASSPATH since jEdit can only run with the bundled BeanShell version 2.0b1.1-jedit-1");
            System.exit(1);
        }
        classManager = new CustomClassManager();
        classManager.setClassLoader(new JARClassLoader());
        global = new NameSpace(classManager, "jEdit embedded BeanShell interpreter");
        global.importPackage("org.gjt.sp.jedit");
        global.importPackage("org.gjt.sp.jedit.browser");
        global.importPackage("org.gjt.sp.jedit.buffer");
        global.importPackage("org.gjt.sp.jedit.gui");
        global.importPackage("org.gjt.sp.jedit.help");
        global.importPackage("org.gjt.sp.jedit.io");
        global.importPackage("org.gjt.sp.jedit.menu");
        global.importPackage("org.gjt.sp.jedit.msg");
        global.importPackage("org.gjt.sp.jedit.options");
        global.importPackage("org.gjt.sp.jedit.pluginmgr");
        global.importPackage("org.gjt.sp.jedit.print");
        global.importPackage("org.gjt.sp.jedit.search");
        global.importPackage("org.gjt.sp.jedit.syntax");
        global.importPackage("org.gjt.sp.jedit.textarea");
        global.importPackage("org.gjt.sp.util");
        interpForMethods = BeanShell.createInterpreter(global);
    }

    static void resetClassManager() {
        classManager.reset();
    }

    private static void setupDefaultVariables(NameSpace namespace, View view) throws UtilEvalError {
        if (view != null) {
            EditPane editPane = view.getEditPane();
            namespace.setVariable("view", view);
            namespace.setVariable("editPane", editPane);
            namespace.setVariable("buffer", editPane.getBuffer());
            namespace.setVariable("textArea", editPane.getTextArea());
            namespace.setVariable("wm", view.getDockableWindowManager());
        }
    }

    private static void resetDefaultVariables(NameSpace namespace) throws UtilEvalError {
        namespace.setVariable("view", null);
        namespace.setVariable("editPane", null);
        namespace.setVariable("buffer", null);
        namespace.setVariable("textArea", null);
        namespace.setVariable("wm", null);
    }

    private static void unwrapException(Exception e) throws Exception {
        Throwable t;
        if (e instanceof TargetError) {
            t = ((TargetError)e).getTarget();
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
        }
        if (e instanceof InvocationTargetException) {
            t = ((InvocationTargetException)e).getTargetException();
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
        }
        throw e;
    }

    private static void handleException(View view, String path, Throwable t) {
        if (t instanceof IOException) {
            VFSManager.error(view, path, "ioerror.read-error", new String[]{t.toString()});
        } else {
            new BeanShellErrorDialog(view, t);
        }
    }

    private static Interpreter createInterpreter(NameSpace nameSpace) {
        return new Interpreter(null, System.out, System.err, false, nameSpace);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class CustomClassManager
    extends BshClassManager {
        private LinkedList listeners = new LinkedList();
        private ReferenceQueue refQueue = new ReferenceQueue();

        CustomClassManager() {
        }

        public synchronized void addListener(BshClassManager.Listener l) {
            Reference deadref;
            this.listeners.add(new WeakReference<BshClassManager.Listener>(l, this.refQueue));
            while ((deadref = this.refQueue.poll()) != null) {
                boolean ok = this.listeners.remove(deadref);
                if (ok || !Interpreter.DEBUG) continue;
                Interpreter.debug("tried to remove non-existent weak ref: " + deadref);
            }
        }

        public void removeListener(BshClassManager.Listener l) {
            throw new Error("unimplemented");
        }

        public void reset() {
            this.classLoaderChanged();
        }

        protected synchronized void classLoaderChanged() {
            this.clearCaches();
            Iterator iter = this.listeners.iterator();
            while (iter.hasNext()) {
                WeakReference wr = (WeakReference)iter.next();
                BshClassManager.Listener l = (BshClassManager.Listener)wr.get();
                if (l == null) {
                    iter.remove();
                    continue;
                }
                l.classLoaderChanged();
            }
        }
    }
}

