package pacote;

import controle.CategoriaDAO;
import modelo.Categoria;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@WebServlet(name = "exibir", urlPatterns = {"/exibir"})
public class CategoriaExibir extends HttpServlet {

    CategoriaDAO catDAO = new CategoriaDAO();

    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            catDAO.init(null);
            List<Categoria> retorno = catDAO.exibirDados();
            request.setAttribute("listaCategoriaJSP", retorno);
            request.getRequestDispatcher("exibir.jsp").forward(request, response);
        } catch (SQLException e) {
            throw new ServletException("Erro ao obter os dados", e);
        }
    }
}
