package visao;

import controle.CategoriaDAO;
import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import modelo.Categoria;

@WebServlet(name = "inserir", urlPatterns = {"/inserir"})
public class CategoriaInserir extends HttpServlet {

    CategoriaDAO catDAO = new CategoriaDAO();
    Categoria cat = new Categoria();

    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {

        try {
            try {

                catDAO.iniciarConexao(null);

            } catch (ClassNotFoundException ex) {

                Logger.getLogger(CategoriaInserir.class.getName()).log(Level.SEVERE, null, ex);
                request.getRequestDispatcher("conexao-erro.jsp").forward(request, response);
            }

            cat.setNome(request.getParameter("vNome"));
            cat.setDescricao(request.getParameter("vDescricao"));
            catDAO.inserirDados(cat);

        } catch (SQLException ex) {

            Logger.getLogger(CategoriaInserir.class.getName()).log(Level.SEVERE, null, ex);
            request.getRequestDispatcher("inserir-erro.jsp").forward(request, response);
        }
        request.getRequestDispatcher("inserir-ok.jsp").forward(request, response);
    }
}
