package visao;

import controle.CategoriaDAO;
import modelo.Categoria;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@WebServlet(name = "exibir", urlPatterns = {"/exibir"})
public class CategoriaExibir extends HttpServlet {

    CategoriaDAO catDAO = new CategoriaDAO();

    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {

        try {
            try {

                catDAO.iniciarConexao(null);

            } catch (ClassNotFoundException ex) {

                Logger.getLogger(CategoriaExibir.class.getName()).log(Level.SEVERE, null, ex);
                request.getRequestDispatcher("conexao-erro.jsp").forward(request, response);
            }

            List<Categoria> retorno = catDAO.exibirDados();
            request.setAttribute("listaCategoriaJSP", retorno);

        } catch (SQLException ex) {

            Logger.getLogger(CategoriaInserir.class.getName()).log(Level.SEVERE, null, ex);
            request.getRequestDispatcher("exibir-erro.jsp").forward(request, response);
        }
        request.getRequestDispatcher("exibir-ok.jsp").forward(request, response);
    }
}
