package controle;

import modelo.Usuario;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;

public class UsuarioDAO {

    private Connection con;

    public void init(ServletConfig config) throws ServletException {
        final String url = "jdbc:oracle:thin:@oracle.inf.poa.ifrs.edu.br:1521:XE";
        final String us = "karen";
        try {
            Class.forName("oracle.jdbc.OracleDriver");
        } catch (ClassNotFoundException ex) {
            Logger.getLogger(UsuarioResposta01.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            con = DriverManager.getConnection(url, us, us);
        } catch (SQLException ex) {
            throw new ServletException(ex);
        }
    }

    public List<Usuario> list() throws SQLException {
        List<Usuario> lista = new ArrayList<>();
        try (
                Connection connection = con;
                PreparedStatement statement = connection.prepareStatement("SELECT * FROM JDBC_USUARIO");
                ResultSet rs = statement.executeQuery();) {
            while (rs.next()) {
                Usuario usuario = new Usuario();
                usuario.setNome(rs.getString(1));
                usuario.setLogin(rs.getString(2));
                usuario.setSenha(rs.getString(3));
                usuario.setTipo(rs.getInt(4));
                usuario.setCpf(rs.getString(5));
                lista.add(usuario);
            }
        }
        return lista;
    }

}
