package br.com.yonathan.faculdades.jdbc;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.sql.*;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;

@WebServlet(name = "App", urlPatterns = {"/App"})
public class App extends HttpServlet {

    private Connection con;

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        final String url = "jdbc:oracle:thin:@oracle.inf.poa.ifrs.edu.br:1521:XE";
        final String us = "karen";
        try {
            Class.forName("oracle.jdbc.OracleDriver");
        } catch (ClassNotFoundException ex) {
            Logger.getLogger(App.class.getName()).log(Level.SEVERE, null, ex);
        }

        try {
            con = DriverManager.getConnection(url, us, us);
        } catch (SQLException ex) {
            throw new ServletException(ex);
        }
    }

    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {

        String sql = "SELECT nome FROM JDBC_USUARIO where ROWNUM = 1";
        String saida = "";
        try (PreparedStatement stm = con.prepareStatement(sql);
                ResultSet rs = stm.executeQuery()) {

            while (rs.next()) {

                saida = rs.getString(1);

            }
            rs.close();
        } catch (SQLException ex) {
            Logger.getLogger(App.class.getName()).log(Level.SEVERE, null, ex);
        }

        request.setAttribute("resultado", saida);

        response.setContentType("text/html;charset=UTF-8");
        request.getRequestDispatcher("resposta.jsp").forward(request, response);
    }

}
