package br.com.yonathan.aula;

import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;

import static br.com.yonathan.aula.R.id.lista;

public class MainActivity extends AppCompatActivity implements View.OnClickListener, AdapterView.OnItemClickListener {

    private Button botao;
    private EditText campoEntrada;
    private TextView campoSaida;
    static final String TXT_ENTRADA = "texto_entrada";
    static final String TXT_SAIDA = "texto_saida";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        botao = (Button) findViewById(R.id.btn_copiar);
        botao.setOnClickListener(this);
        campoEntrada = (EditText) findViewById(R.id.editText_01);
        campoSaida = (TextView) findViewById(R.id.TextView_02);

        final String[] meses = {"Janeiro", "Fevereiro", "Março", "Abril", "Maio", "Junho",
                "Julho", "Agosto", "Setembro", "Outubro", "Novembro", "Dezembro"};

        final ListView LV = (ListView) this.findViewById(lista);

        ArrayAdapter<String> adapter = new ArrayAdapter<String>(this, android.R.layout.simple_list_item_1);
        adapter.addAll(meses);

        LV.setAdapter(adapter);
        LV.setOnItemClickListener(this);

    }

    @Override
    public void onSaveInstanceState(Bundle savedInstanceState) {
        savedInstanceState.putString(TXT_ENTRADA, campoEntrada.getText().toString());
        savedInstanceState.putString(TXT_SAIDA, campoSaida.getText().toString());
        super.onSaveInstanceState(savedInstanceState);
    }

    @Override
    public void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        if (savedInstanceState != null) {
            campoEntrada.setText(savedInstanceState.getString(TXT_ENTRADA));
            campoSaida.setText(savedInstanceState.getString(TXT_SAIDA));
        }
    }

    @Override
    public void onClick(View view) {
        campoSaida.setText(campoEntrada.getText());
    }

    @Override
    public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
        String item = ((TextView) view).getText().toString();
        Toast.makeText(getBaseContext(), item, Toast.LENGTH_SHORT).show();
    }
}