package br.com.yonathan.aula;

import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;

public class MainActivity extends AppCompatActivity implements View.OnClickListener {

    private Button botao;
    private EditText campoEntrada;
    private TextView campoSaida;
    static final String TXT_ENTRADA = "texto_entrada";
    static final String TXT_SAIDA = "texto_saida";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        botao = (Button) findViewById(R.id.btn_copiar);
        botao.setOnClickListener(this);
        campoEntrada = (EditText) findViewById(R.id.editText_01);
        campoSaida = (TextView) findViewById(R.id.TextView_02);
    }

    @Override
    public void onSaveInstanceState(Bundle savedInstanceState) {
        savedInstanceState.putString(TXT_ENTRADA, campoEntrada.getText().toString());
        savedInstanceState.putString(TXT_SAIDA, campoSaida.getText().toString());
        super.onSaveInstanceState(savedInstanceState);
    }

    @Override
    public void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        if (savedInstanceState != null) {
            campoEntrada.setText(savedInstanceState.getString(TXT_ENTRADA));
            campoSaida.setText(savedInstanceState.getString(TXT_SAIDA));
        }
    }

    @Override
    public void onClick(View view) {
        campoSaida.setText(campoEntrada.getText());
    }
}